/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.chatchannels;

import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannel;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelService;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.session.SppInteractor;

@IocBean
public class ReportChatChannelService {
    @ConfigProperty(value="%lang%:reports.chatchannel.prefix")
    public String chatChannelPrefix;
    @ConfigProperty(value="%lang%:reports.chatchannel.chatline")
    public String chatChannelLine;
    @ConfigProperty(value="%lang%:reports.chatchannel.openingmessage")
    public String chatChannelOpeningMessage;
    private final ChatChannelService chatChannelService;

    public ReportChatChannelService(ChatChannelService chatChannelService) {
        this.chatChannelService = chatChannelService;
    }

    public void openChannel(IReport report) {
        this.openChannel(null, report);
    }

    public void openChannel(SppInteractor creator, IReport report) {
        Optional<ChatChannel> channel;
        HashSet<UUID> members = new HashSet<UUID>();
        members.add(report.getReporterUuid());
        if (creator != null && !creator.getId().equals(Constants.CONSOLE_UUID)) {
            members.add(creator.getId());
        }
        if (report.getStaffUuid() != null) {
            members.add(report.getStaffUuid());
        }
        if (!(channel = this.chatChannelService.findChannel(String.valueOf(report.getId()), ChatChannelType.REPORT)).isPresent()) {
            this.chatChannelService.create(String.valueOf(report.getId()), this.chatChannelPrefix, this.chatChannelLine, this.chatChannelOpeningMessage, members, ChatChannelType.REPORT);
        }
    }
}

