/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.chatchannels;

import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannel;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelService;
import net.shortninja.staffplus.core.domain.staff.reporting.chatchannels.ReportChatChannelService;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportStatusesConfigTransformer;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.reports.AcceptReportEvent;
import net.shortninja.staffplusplus.reports.CreateReportEvent;
import net.shortninja.staffplusplus.reports.DeleteReportEvent;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.RejectReportEvent;
import net.shortninja.staffplusplus.reports.ReopenReportEvent;
import net.shortninja.staffplusplus.reports.ReportStatus;
import net.shortninja.staffplusplus.reports.ResolveReportEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="reports-module.chatchannels.enabled=true")
public class ReportChatChannelListener
implements Listener {
    @ConfigProperty(value="reports-module.chatchannels.open-on")
    @ConfigTransformer(value={ReportStatusesConfigTransformer.class})
    private List<ReportStatus> chatchannelsOpenStatuses;
    @ConfigProperty(value="reports-module.chatchannels.close-on")
    @ConfigTransformer(value={ReportStatusesConfigTransformer.class})
    private List<ReportStatus> chatchannelsCloseStatuses;
    private final ChatChannelService chatChannelService;
    private final ReportChatChannelService reportChatChannelService;
    private final BukkitUtils bukkitUtils;

    public ReportChatChannelListener(ChatChannelService chatChannelService, ReportChatChannelService reportChatChannelService, BukkitUtils bukkitUtils) {
        this.chatChannelService = chatChannelService;
        this.reportChatChannelService = reportChatChannelService;
        this.bukkitUtils = bukkitUtils;
    }

    private void openChannel(IReport report) {
        Optional<ChatChannel> channel = this.chatChannelService.findChannel(String.valueOf(report.getId()), ChatChannelType.REPORT);
        if (!channel.isPresent()) {
            this.reportChatChannelService.openChannel(report);
        }
    }

    @EventHandler
    public void onReportAccepted(AcceptReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.IN_PROGRESS, reportEvent.getReport());
    }

    @EventHandler
    public void onReportResolved(ResolveReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.RESOLVED, reportEvent.getReport());
    }

    @EventHandler
    public void onReportRejected(RejectReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.REJECTED, reportEvent.getReport());
    }

    @EventHandler
    public void onReportOpened(CreateReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.OPEN, reportEvent.getReport());
    }

    @EventHandler
    public void onReportReopened(ReopenReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.OPEN, reportEvent.getReport());
    }

    @EventHandler
    public void onReportDeleted(DeleteReportEvent reportEvent) {
        this.openOrCloseChannels(ReportStatus.DELETED, reportEvent.getReport());
    }

    private void openOrCloseChannels(ReportStatus status, IReport report) {
        this.bukkitUtils.runTaskAsync(() -> {
            if (this.chatchannelsOpenStatuses.contains((Object)status)) {
                this.openChannel(report);
            }
            if (this.chatchannelsCloseStatuses.contains((Object)status)) {
                this.closeChannel(report);
            }
        });
    }

    private void closeChannel(IReport report) {
        this.chatChannelService.closeChannel(String.valueOf(report.getId()), ChatChannelType.REPORT);
    }
}

