/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.chatchannels;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelService;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.session.SppInteractor;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:reports.chat", permissions={"permissions:reports.chat"}, description="Send a message on your report chat channel", usage="[channelId] [message]", playerRetrievalStrategy=PlayerRetrievalStrategy.NONE)
@IocBean(conditionalOnProperty="reports-module.chatchannels.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ReportChatChannelCmd
extends AbstractCmd {
    private final ChatChannelService chatChannelService;
    private final BukkitUtils bukkitUtils;

    public ReportChatChannelCmd(PermissionHandler permissionHandler, Messages messages, CommandService commandService, ChatChannelService chatChannelService, BukkitUtils bukkitUtils) {
        super(messages, permissionHandler, commandService);
        this.chatChannelService = chatChannelService;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        String channelId = args[0];
        String message = JavaUtils.compileWords(args, 1);
        UUID senderUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : Constants.CONSOLE_UUID;
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        SppInteractor sppInteractor = new SppInteractor(senderUuid, senderName, sender);
        this.bukkitUtils.runTaskAsync(sender, () -> this.chatChannelService.sendOnChannel(sppInteractor, channelId, message, ChatChannelType.REPORT));
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 2;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            if (sender instanceof Player) {
                return this.chatChannelService.getMyChannelIds((Player)sender, ChatChannelType.REPORT).stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
            }
            return this.chatChannelService.getAllChannelIds(ChatChannelType.REPORT).stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

