/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.bungee.receive;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportReopenedBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportReopenedBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(server-sync-module.report-sync)")
public class ReportReopenBungeeListener
implements PluginMessageListener {
    private final BungeeClient bungeeClient;
    private final ServerSyncConfiguration serverSyncConfiguration;

    public ReportReopenBungeeListener(BungeeClient bungeeClient, ServerSyncConfiguration serverSyncConfiguration) {
        this.bungeeClient = bungeeClient;
        this.serverSyncConfiguration = serverSyncConfiguration;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional reopenedBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.report-reopen", message, ReportReopenedBungeeDto.class);
        if (reopenedBungeeDto.isPresent() && this.serverSyncConfiguration.reportSyncServers.matchesServer(((ReportReopenedBungeeDto)reopenedBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new ReportReopenedBungeeEvent((ReportReopenedBungeeDto)reopenedBungeeDto.get()));
        }
    }
}

