/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto;

import java.util.UUID;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplus.core.domain.location.SppLocation;
import net.shortninja.staffplusplus.ILocation;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.ReportStatus;

public class ReportBungeeDto
extends BungeeMessage {
    private final int id;
    private final UUID culpritUuid;
    private final String culpritName;
    private final String reason;
    private final UUID reporterUuid;
    private final String reporterName;
    private final String staffName;
    private final UUID staffUuid;
    private final ReportStatus reportStatus;
    private final String closeReason;
    private final SppLocation sppLocation;
    private final String type;

    public ReportBungeeDto(IReport report) {
        super(report.getServerName());
        this.id = report.getId();
        this.culpritUuid = report.getCulpritUuid();
        this.culpritName = report.getCulpritName();
        this.reason = report.getReason();
        this.reporterUuid = report.getReporterUuid();
        this.reporterName = report.getReporterName();
        this.staffName = report.getStaffName();
        this.staffUuid = report.getStaffUuid();
        this.reportStatus = report.getReportStatus();
        this.closeReason = report.getCloseReason();
        this.sppLocation = report.getSppLocation().orElse(null);
        this.type = report.getReportType().orElse(null);
    }

    public int getId() {
        return this.id;
    }

    public UUID getCulpritUuid() {
        return this.culpritUuid;
    }

    public String getCulpritName() {
        return this.culpritName;
    }

    public String getReason() {
        return this.reason;
    }

    public UUID getReporterUuid() {
        return this.reporterUuid;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public String getStaffName() {
        return this.staffName;
    }

    public UUID getStaffUuid() {
        return this.staffUuid;
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public String getCloseReason() {
        return this.closeReason;
    }

    public ILocation getSppLocation() {
        return this.sppLocation;
    }

    public String getType() {
        return this.type;
    }
}

