/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.bungee;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportDeletedBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportReopenedBungeeDto;
import net.shortninja.staffplusplus.reports.AcceptReportEvent;
import net.shortninja.staffplusplus.reports.CreateReportEvent;
import net.shortninja.staffplusplus.reports.DeleteReportEvent;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.RejectReportEvent;
import net.shortninja.staffplusplus.reports.ReopenReportEvent;
import net.shortninja.staffplusplus.reports.ResolveReportEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class ReportBungeeNotifier
implements Listener {
    private final BungeeClient bungeeClient;

    public ReportBungeeNotifier(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    @EventHandler
    public void onCreate(CreateReportEvent event) {
        this.sendBungeeNotification(event.getReport(), "staffplusplus.report-created");
    }

    @EventHandler
    public void onDelete(DeleteReportEvent event) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        this.bungeeClient.sendMessage(player, "staffplusplus.report-deleted", new ReportDeletedBungeeDto(event.getReport(), event.getDeletedByName()));
    }

    @EventHandler
    public void onAccept(AcceptReportEvent event) {
        this.sendBungeeNotification(event.getReport(), "staffplusplus.report-accepted");
    }

    @EventHandler
    public void onResolve(ResolveReportEvent event) {
        this.sendBungeeNotification(event.getReport(), "staffplusplus.report-closed");
    }

    @EventHandler
    public void onReject(RejectReportEvent event) {
        this.sendBungeeNotification(event.getReport(), "staffplusplus.report-closed");
    }

    @EventHandler
    public void onReopen(ReopenReportEvent event) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        this.bungeeClient.sendMessage(player, "staffplusplus.report-reopen", new ReportReopenedBungeeDto(event.getReport(), event.getReopenedByName()));
    }

    private void sendBungeeNotification(IReport report, String channel) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        this.bungeeClient.sendMessage(player, channel, new ReportBungeeDto(report));
    }
}

