/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.actions;

import java.util.Arrays;
import java.util.Map;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplusplus.reports.IReport;

public class ReportTypeActionFilter
implements ActionFilter {
    private static final String TYPE = "type";
    private final IReport report;

    public ReportTypeActionFilter(IReport report) {
        this.report = report;
    }

    @Override
    public boolean isValidAction(CreateStoredCommandRequest createStoredCommandRequest, Map<String, String> filters) {
        if (!filters.containsKey(TYPE)) {
            return true;
        }
        if (!this.report.getReportType().isPresent()) {
            return false;
        }
        return this.checkFilter(filters, this.report.getReportType().get());
    }

    private boolean checkFilter(Map<String, String> filters, String value) {
        return Arrays.asList(filters.get(TYPE).split(",")).contains(value.toLowerCase());
    }
}

