/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.reporting.actions.ReportCulpritActionFilter;
import net.shortninja.staffplus.core.domain.staff.reporting.actions.ReportTypeActionFilter;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import net.shortninja.staffplusplus.reports.AcceptReportEvent;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.RejectReportEvent;
import net.shortninja.staffplusplus.reports.ReopenReportEvent;
import net.shortninja.staffplusplus.reports.ResolveReportEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class ReportActionsHook
implements Listener {
    private final ActionService actionService;
    private final PlayerManager playerManager;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final BukkitUtils bukkitUtils;
    private final ReportConfiguration reportConfiguration;

    public ReportActionsHook(ActionService actionService, PlayerManager playerManager, ConfiguredCommandMapper configuredCommandMapper, BukkitUtils bukkitUtils, ReportConfiguration reportConfiguration) {
        this.actionService = actionService;
        this.playerManager = playerManager;
        this.configuredCommandMapper = configuredCommandMapper;
        this.bukkitUtils = bukkitUtils;
        this.reportConfiguration = reportConfiguration;
    }

    @EventHandler
    public void onAccept(AcceptReportEvent event) {
        this.executeActions(event.getReport(), this.reportConfiguration.getAcceptReportActions());
    }

    @EventHandler
    public void onReject(RejectReportEvent event) {
        this.executeActions(event.getReport(), this.reportConfiguration.getRejectReportActions());
    }

    @EventHandler
    public void onReopen(ReopenReportEvent event) {
        this.executeActions(event.getReport(), this.reportConfiguration.getReopenReportActions());
    }

    @EventHandler
    public void onResolve(ResolveReportEvent event) {
        this.executeActions(event.getReport(), this.reportConfiguration.getResolveReportActions());
    }

    private void executeActions(IReport report, List<ConfiguredCommand> commands) {
        if (commands.isEmpty()) {
            return;
        }
        this.bukkitUtils.runTaskAsync(() -> {
            Optional<SppPlayer> reporter = this.playerManager.getOnOrOfflinePlayer(report.getReporterUuid());
            Optional<SppPlayer> assigned = this.playerManager.getOnOrOfflinePlayer(report.getStaffUuid());
            Optional<SppPlayer> culprit = report.getCulpritUuid() != null ? this.playerManager.getOnOrOfflinePlayer(report.getCulpritUuid()) : Optional.empty();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            reporter.ifPresent(sppPlayer -> placeholders.put("%reporter%", sppPlayer.getUsername()));
            assigned.ifPresent(sppPlayer -> placeholders.put("%assigned%", sppPlayer.getUsername()));
            culprit.ifPresent(sppPlayer -> placeholders.put("%culprit%", sppPlayer.getUsername()));
            HashMap<String, OfflinePlayer> targets = new HashMap<String, OfflinePlayer>();
            reporter.ifPresent(sppPlayer -> targets.put("reporter", sppPlayer.getOfflinePlayer()));
            assigned.ifPresent(sppPlayer -> targets.put("assigned", sppPlayer.getOfflinePlayer()));
            culprit.ifPresent(sppPlayer -> targets.put("culprit", sppPlayer.getOfflinePlayer()));
            this.actionService.createCommands(this.configuredCommandMapper.toCreateRequests(commands, placeholders, targets, Arrays.asList(new ReportTypeActionFilter(report), new ReportCulpritActionFilter(report))));
        });
    }
}

