/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.bungee.ServerSwitcher;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionRunStrategy;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionInfo;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionProvider;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.config.InfractionsConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.database.ReportRepository;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.reports.CreateReportEvent;
import net.shortninja.staffplusplus.reports.ReportFilters;
import net.shortninja.staffplusplus.reports.ReportStatus;
import net.shortninja.staffplusplus.session.SppInteractor;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={InfractionProvider.class})
public class ReportService
implements InfractionProvider,
net.shortninja.staffplusplus.reports.ReportService {
    @ConfigProperty(value="permissions:report-bypass")
    private String permissionReportBypass;
    private final PermissionHandler permission;
    private final Options options;
    private final Messages messages;
    private final PlayerManager playerManager;
    private final ReportRepository reportRepository;
    private final ActionService actionService;
    private final InfractionsConfiguration infractionsConfiguration;

    public ReportService(PermissionHandler permission, Options options, ReportRepository reportRepository, Messages messages, PlayerManager playerManager, ActionService actionService, InfractionsConfiguration infractionsConfiguration) {
        this.permission = permission;
        this.options = options;
        this.reportRepository = reportRepository;
        this.messages = messages;
        this.playerManager = playerManager;
        this.actionService = actionService;
        this.infractionsConfiguration = infractionsConfiguration;
    }

    public List<Report> getReported(SppPlayer player, int offset, int amount) {
        return this.reportRepository.getReports(player.getId(), offset, amount);
    }

    public List<Report> findReports(ReportFilters reportFilters, int offset, int amount) {
        return this.reportRepository.findReports(reportFilters, offset, amount);
    }

    public List<Report> getReported(UUID playerUuid, int offset, int amount) {
        SppPlayer user = this.getUser(playerUuid);
        return this.reportRepository.getReports(user.getId(), offset, amount);
    }

    public void sendReport(SppInteractor player, SppPlayer user, String reason) {
        this.sendReport(player, user, reason, null);
    }

    public void sendReport(SppInteractor sppInteractor, SppPlayer user, String reason, String type) {
        if (StringUtils.isEmpty(reason)) {
            throw new BusinessException("Report cannot be created with the reason");
        }
        if (user.isOnline() && this.permission.has(user.getPlayer(), this.permissionReportBypass)) {
            this.messages.send(sppInteractor, this.messages.bypassed, this.messages.prefixGeneral);
            return;
        }
        Report report = new Report(user.getId(), user.getUsername(), reason, sppInteractor.getUsername(), sppInteractor.getId(), ReportStatus.OPEN, ZonedDateTime.now(), sppInteractor.isBukkitPlayer() ? ((Player)sppInteractor.getCommandSender().get()).getLocation() : null, type, this.options.serverName);
        int id = this.reportRepository.addReport(report);
        report.setId(id);
        BukkitUtils.sendEvent(new CreateReportEvent(report));
    }

    public void sendReport(SppInteractor player, String reason) {
        this.sendReport(player, reason, null);
    }

    public void sendReport(SppInteractor sppInteractor, String reason, String type) {
        Report report = new Report(null, null, reason, sppInteractor.getUsername(), sppInteractor.getId(), ReportStatus.OPEN, ZonedDateTime.now(), sppInteractor.isBukkitPlayer() ? ((Player)sppInteractor.getCommandSender().get()).getLocation() : null, type, this.options.serverName);
        int id = this.reportRepository.addReport(report);
        report.setId(id);
        BukkitUtils.sendEvent(new CreateReportEvent(report));
    }

    public Collection<Report> getUnresolvedReports(int offset, int amount) {
        return this.reportRepository.getUnresolvedReports(offset, amount);
    }

    public Collection<Report> getAllAssignedReports(int offset, int amount) {
        return this.reportRepository.getAssignedReports(offset, amount);
    }

    public Collection<Report> getAssignedReports(UUID staffUuid, int offset, int amount) {
        return this.reportRepository.getAssignedReports(staffUuid, offset, amount);
    }

    public Collection<Report> getMyReports(UUID reporterUuid, int offset, int amount) {
        return this.reportRepository.getMyReports(reporterUuid, offset, amount);
    }

    public List<Report> getMyReports(UUID reporterUuid) {
        return this.reportRepository.getMyReports(reporterUuid);
    }

    private SppPlayer getUser(UUID playerUuid) {
        Optional<SppPlayer> player = this.playerManager.getOnOrOfflinePlayer(playerUuid);
        if (!player.isPresent()) {
            throw new BusinessException(this.messages.playerNotRegistered, this.messages.prefixGeneral);
        }
        return player.get();
    }

    public Report getReport(int reportId) {
        return this.reportRepository.findReport(reportId).orElseThrow(() -> new BusinessException("Report with id [" + reportId + "] not found", this.messages.prefixReports));
    }

    public void goToReportLocation(Player player, int reportId) {
        Report report = this.getReport(reportId);
        Location location = report.getLocation().orElseThrow(() -> new BusinessException("Cannot teleport to report, report has no known location"));
        if (report.getServerName().equalsIgnoreCase(this.options.serverName)) {
            player.teleport(location);
            this.messages.send((CommandSender)player, "You have been teleported to the location where this report was created", this.messages.prefixReports);
        } else {
            this.actionService.createCommand(CreateStoredCommandRequest.CreateStoredCommandRequestBuilder.commandBuilder().command("staffplusplus:teleport-to-report " + reportId).executor(player.getUniqueId()).executorRunStrategy(ActionRunStrategy.DELAY).serverName(report.getServerName()).build());
            ServerSwitcher.switchServer(player, report.getServerName());
        }
    }

    @Override
    public long getReportCount(ReportFilters reportFilter) {
        return this.reportRepository.getReportCount(reportFilter);
    }

    @Override
    public List<? extends Infraction> getInfractions(Player executor, UUID playerUUID) {
        if (!this.infractionsConfiguration.isShowReported()) {
            return Collections.emptyList();
        }
        return this.reportRepository.getReportsByOffender(playerUUID);
    }

    @Override
    public Optional<InfractionInfo> getInfractionsInfo() {
        if (!this.infractionsConfiguration.isShowReported()) {
            return Optional.empty();
        }
        return Optional.of(new InfractionInfo(InfractionType.REPORTED, this.reportRepository.getReportedCount()));
    }

    @Override
    public InfractionType getType() {
        return InfractionType.REPORTED;
    }
}

