/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.JsonSenderService;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class ReportListener
implements Listener {
    private final ReportService reportService;
    private final PermissionHandler permission;
    private final ReportConfiguration reportConfiguration;
    private final JsonSenderService jsonSenderService;

    public ReportListener(ReportService reportService, PermissionHandler permission, ReportConfiguration reportConfiguration, JsonSenderService jsonSenderService) {
        this.reportService = reportService;
        this.permission = permission;
        this.reportConfiguration = reportConfiguration;
        this.jsonSenderService = jsonSenderService;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void notifyReports(StaffPlusPlusJoinedEvent event) {
        if (!this.reportConfiguration.isNotifyReporterOnJoin()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            List<Report> reports = this.reportService.getMyReports(event.getPlayer().getUniqueId());
            List openReports = reports.stream().filter(r -> !r.getReportStatus().isClosed()).collect(Collectors.toList());
            if (!openReports.isEmpty()) {
                JSONMessage message = JavaUtils.buildClickableMessage("You have " + openReports.size() + " open reports", "View your reports!", "Click to view your reports", this.reportConfiguration.getMyReportsCmd(), this.permission.has(event.getPlayer(), this.reportConfiguration.getMyReportsPermission()));
                this.jsonSenderService.send(message, event.getPlayer());
            }
        });
    }
}

