/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.domain.location.SppLocation;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplusplus.ILocation;
import net.shortninja.staffplusplus.investigate.evidence.Evidence;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.ReportStatus;
import org.bukkit.Location;

public class Report
implements IReport,
Infraction,
Evidence {
    private final UUID culpritUuid;
    private final String culpritName;
    private final String reason;
    private ZonedDateTime timestamp;
    private final UUID reporterUuid;
    private String reporterName;
    private String staffName;
    private UUID staffUuid;
    private ReportStatus reportStatus;
    private int id;
    private String closeReason;
    private final String serverName;
    private final transient Location location;
    private SppLocation sppLocation;
    private final String type;

    public Report(UUID culpritUuid, String culpritName, int id, String reason, String reporterName, UUID reporterUuid, long time, ReportStatus reportStatus, String staffName, UUID staffUuid, String closeReason, String serverName, Location location, SppLocation sppLocation, String type) {
        this.culpritUuid = culpritUuid;
        this.culpritName = culpritName;
        this.reason = reason;
        this.reporterName = reporterName;
        this.reporterUuid = reporterUuid;
        this.id = id;
        this.timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        this.reportStatus = reportStatus;
        this.staffName = staffName;
        this.staffUuid = staffUuid;
        this.closeReason = closeReason;
        this.serverName = serverName;
        this.location = location;
        this.sppLocation = sppLocation;
        this.type = type;
    }

    public Report(UUID culpritUuid, String culpritName, String reason, String reporterName, UUID reporterUuid, ReportStatus reportStatus, ZonedDateTime timestamp, Location location, String type, String serverName) {
        this.culpritUuid = culpritUuid;
        this.culpritName = culpritName;
        this.reason = reason;
        this.reporterName = reporterName;
        this.reporterUuid = reporterUuid;
        this.reportStatus = reportStatus;
        this.timestamp = timestamp;
        this.location = location;
        this.type = type;
        this.serverName = serverName;
        if (location != null) {
            this.sppLocation = new SppLocation(location, serverName);
        }
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getEvidenceType() {
        return "REPORT";
    }

    @Override
    public String getDescription() {
        return this.reason;
    }

    public UUID getUuid() {
        return this.culpritUuid;
    }

    @Override
    public UUID getCulpritUuid() {
        return this.culpritUuid;
    }

    @Override
    public String getCulpritName() {
        return this.culpritName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getReporterName() {
        return this.reporterName;
    }

    public void setReporterName(String reporterName) {
        this.reporterName = reporterName;
    }

    @Override
    public UUID getReporterUuid() {
        return this.reporterUuid;
    }

    @Override
    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }

    @Override
    public UUID getStaffUuid() {
        return this.staffUuid;
    }

    public void setStaffUuid(UUID staffUuid) {
        this.staffUuid = staffUuid;
    }

    @Override
    public String getStaffName() {
        return this.staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return this.timestamp;
    }

    @Override
    public String getCloseReason() {
        return this.closeReason;
    }

    public void setCloseReason(String closeReason) {
        this.closeReason = closeReason;
    }

    @Override
    public InfractionType getInfractionType() {
        return InfractionType.REPORTED;
    }

    @Override
    public Long getCreationTimestamp() {
        return Timestamp.valueOf(this.timestamp.toLocalDateTime()).getTime();
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    @Override
    public Optional<ILocation> getSppLocation() {
        return Optional.ofNullable(this.sppLocation);
    }

    @Override
    public Optional<String> getReportType() {
        return Optional.ofNullable(this.type);
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }
}

