/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplusplus.session.IPlayerSession;

@GuiController
public class ProtectedPlayersGuiController {
    private final PlayerManager playerManager;
    private final OnlineSessionsManager onlineSessionsManager;

    public ProtectedPlayersGuiController(PlayerManager playerManager, OnlineSessionsManager onlineSessionsManager) {
        this.playerManager = playerManager;
        this.onlineSessionsManager = onlineSessionsManager;
    }

    @GuiAction(value="protected-players/view")
    public AsyncGui<GuiTemplate> getOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List players = this.onlineSessionsManager.getAll().stream().filter(IPlayerSession::isProtected).map(s -> this.playerManager.getOnlinePlayer(s.getUuid())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List pagedPlayers = JavaUtils.getPageOfList(players, page, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("players", pagedPlayers);
            return GuiTemplate.template("gui/protect/player-overview.ftl", params);
        });
    }
}

