/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect.gui;

import java.util.HashMap;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.protect.ProtectService;
import net.shortninja.staffplus.core.domain.staff.protect.ProtectedArea;
import net.shortninja.staffplus.core.domain.staff.protect.config.ProtectConfiguration;
import net.shortninja.staffplus.core.domain.staff.teleport.TeleportService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class ProtectedAreasGuiController {
    private static final int PAGE_SIZE = 45;
    private final ProtectService protectService;
    private final TeleportService teleportService;
    private final BukkitUtils bukkitUtils;
    private final ProtectConfiguration protectConfiguration;

    public ProtectedAreasGuiController(ProtectService protectService, TeleportService teleportService, BukkitUtils bukkitUtils, ProtectConfiguration protectConfiguration) {
        this.protectService = protectService;
        this.teleportService = teleportService;
        this.bukkitUtils = bukkitUtils;
        this.protectConfiguration = protectConfiguration;
    }

    @GuiAction(value="protected-areas/view")
    public AsyncGui<GuiTemplate> getOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", this.protectConfiguration.modeGuiProtectedAreasTitle);
            params.put("areas", this.protectService.getAllProtectedAreasPaginated(page * 45, 45));
            return GuiTemplate.template("gui/protect/area-overview.ftl", params);
        });
    }

    @GuiAction(value="protected-areas/view/detail")
    public AsyncGui<GuiTemplate> getAreaDetail(@GuiParam(value="areaId") int areaId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("area", this.protectService.getById(areaId));
            return GuiTemplate.template("gui/protect/area-detail.ftl", params);
        });
    }

    @GuiAction(value="protected-areas/delete")
    public void delete(Player player, @GuiParam(value="areaId") int areaId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.protectService.deleteProtectedArea(player, areaId));
    }

    @GuiAction(value="protected-areas/teleport")
    public void teleport(Player player, @GuiParam(value="areaId") int areaId) {
        ProtectedArea protectedArea = this.protectService.getById(areaId);
        this.teleportService.teleportSelf(player, protectedArea.getCornerPoint1());
    }
}

