/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect.cmd;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@Command(command="commands:protect-player", permissions={"permissions:protect-player"}, description="Protect a player from all damage", usage="[player]", delayable=true, playerRetrievalStrategy=PlayerRetrievalStrategy.ONLINE)
@IocBean(conditionalOnProperty="protect-module.player-enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ProtectPlayerCmd
extends AbstractCmd {
    private final OnlineSessionsManager sessionManager;

    public ProtectPlayerCmd(Messages messages, OnlineSessionsManager sessionManager, CommandService commandService, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.sessionManager = sessionManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        PlayerSession playerSession;
        playerSession.setProtected(!(playerSession = this.sessionManager.get(player.getPlayer())).isProtected());
        if (playerSession.isProtected()) {
            this.messages.send(sender, player.getUsername() + " is now protected from all damage", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player.getPlayer(), "You have been protected from all damage by a staff member", this.messages.prefixGeneral);
        } else {
            this.messages.send(sender, player.getUsername() + " is no longer protected from all damage", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player.getPlayer(), "You are no longer protected from damage", this.messages.prefixGeneral);
        }
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.of(args[0]);
    }
}

