/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.protect.ProtectService;
import net.shortninja.staffplus.core.domain.staff.protect.ProtectedArea;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:protect-area", permissions={"permissions:protect-area"}, description="Protect an area around you.", usage="[radius] [area name]", playerRetrievalStrategy=PlayerRetrievalStrategy.NONE)
@IocBean(conditionalOnProperty="protect-module.area-enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ProtectAreaCmd
extends AbstractCmd {
    private static final String CREATE = "create";
    private static final String DELETE = "delete";
    private final ProtectService protectService;

    public ProtectAreaCmd(Messages messages, ProtectService protectService, CommandService commandService, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.protectService = protectService;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (!(sender instanceof Player)) {
            throw new BusinessException(this.messages.onlyPlayers);
        }
        String action = args[0];
        Player executingPlayer = (Player)sender;
        if (action.equalsIgnoreCase(CREATE)) {
            int radius = Integer.parseInt(args[1]);
            String name = JavaUtils.compileWords(args, 2);
            this.protectService.createProtectedArea(radius, name, executingPlayer, executingPlayer.getLocation().getWorld(), executingPlayer.getLocation());
            return true;
        }
        if (action.equalsIgnoreCase(DELETE)) {
            String name = JavaUtils.compileWords(args, 1);
            this.protectService.deleteProtectedArea(executingPlayer, name);
            return true;
        }
        throw new BusinessException("&CPlease choose a correct action [create|delete]");
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return 3;
        }
        String action = args[0];
        if (action.equalsIgnoreCase(CREATE)) {
            return 3;
        }
        if (action.equalsIgnoreCase(DELETE)) {
            return 2;
        }
        return 3;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length <= 1) {
            suggestions.add(CREATE);
            suggestions.add(DELETE);
            return suggestions.stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String action = args[0];
            if (action.equalsIgnoreCase(CREATE)) {
                suggestions.add("5");
                suggestions.add("10");
                suggestions.add("20");
            }
            if (action.equalsIgnoreCase(DELETE)) {
                suggestions.addAll(this.protectService.getAllProtectedAreas().stream().map(ProtectedArea::getName).collect(Collectors.toList()));
            }
            return suggestions.stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
        }
        return suggestions;
    }
}

