/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect;

import java.util.UUID;
import org.bukkit.Location;

public class ProtectedArea {
    private int id;
    private String name;
    private Location cornerPoint1;
    private Location cornerPoint2;
    private UUID protectedByUuid;

    public ProtectedArea(int id, String name, Location cornerPoint1, Location cornerPoint2, UUID protectedByUuid) {
        this.id = id;
        this.name = name;
        this.cornerPoint1 = cornerPoint1;
        this.cornerPoint2 = cornerPoint2;
        this.protectedByUuid = protectedByUuid;
    }

    public ProtectedArea(String name, Location location1, Location location2, UUID protectedByUuid) {
        this.name = name;
        this.cornerPoint1 = location1;
        this.cornerPoint2 = location2;
        this.protectedByUuid = protectedByUuid;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Location getCornerPoint1() {
        return this.cornerPoint1;
    }

    public Location getCornerPoint2() {
        return this.cornerPoint2;
    }

    public UUID getProtectedByUuid() {
        return this.protectedByUuid;
    }

    public boolean isInArea(Location location) {
        if (!location.getWorld().getName().equalsIgnoreCase(this.cornerPoint1.getWorld().getName())) {
            return false;
        }
        int minX = Math.min(this.cornerPoint1.getBlockX(), this.cornerPoint2.getBlockX());
        int minZ = Math.min(this.cornerPoint1.getBlockZ(), this.cornerPoint2.getBlockZ());
        int maxX = Math.max(this.cornerPoint1.getBlockX(), this.cornerPoint2.getBlockX());
        int maxZ = Math.max(this.cornerPoint1.getBlockZ(), this.cornerPoint2.getBlockZ());
        return location.getBlockX() >= minX && location.getBlockX() <= maxX && location.getBlockZ() >= minZ && location.getBlockZ() <= maxZ;
    }
}

