/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.protect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.protect.ProtectedArea;
import net.shortninja.staffplus.core.domain.staff.protect.config.ProtectConfiguration;
import net.shortninja.staffplus.core.domain.staff.protect.database.ProtectedAreaRepository;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class ProtectService {
    private final ProtectConfiguration protectConfiguration;
    private List<ProtectedArea> protectedAreas;
    private final ProtectedAreaRepository protectedAreaRepository;
    private final Messages messages;
    private final PlayerSettingsRepository playerSettingsRepository;

    public ProtectService(ProtectedAreaRepository protectedAreaRepository, Messages messages, ProtectConfiguration protectConfiguration, PlayerSettingsRepository playerSettingsRepository) {
        this.protectedAreaRepository = protectedAreaRepository;
        this.messages = messages;
        this.protectConfiguration = protectConfiguration;
        this.playerSettingsRepository = playerSettingsRepository;
    }

    public boolean isLocationProtected(Player player, Location location) {
        if (this.playerSettingsRepository.get((OfflinePlayer)player).isInStaffMode()) {
            return false;
        }
        boolean protectedArea = this.getAllProtectedAreas().stream().anyMatch(a -> a.isInArea(location));
        if (protectedArea) {
            this.messages.send((CommandSender)player, "&7This area has been protected by a Staff Member", this.messages.prefixProtect);
        }
        return protectedArea;
    }

    public void createProtectedArea(int size, String name, Player player, World world, Location location) {
        Optional<ProtectedArea> existingArea = this.protectedAreaRepository.findByName(name);
        if (existingArea.isPresent()) {
            throw new BusinessException("&bA protected area with this name already exists. Please delete the existing area or choose another name.", this.messages.prefixProtect);
        }
        if (size > this.protectConfiguration.areaMaxSize) {
            throw new BusinessException("&bCannot create area, size is too big. Max size [" + this.protectConfiguration.areaMaxSize + "]", this.messages.prefixProtect);
        }
        int half = size / 2;
        int correction = size % 2 == 0 ? 1 : 0;
        Location location1 = new Location(world, (double)(location.getBlockX() + half), (double)location.getBlockY(), (double)(location.getBlockZ() + half));
        Location location2 = new Location(world, (double)(location.getBlockX() - half + correction), (double)location.getBlockY(), (double)(location.getBlockZ() - half + correction));
        ProtectedArea protectedArea = new ProtectedArea(name, location1, location2, player.getUniqueId());
        this.getAllProtectedAreas().add(protectedArea);
        this.protectedAreaRepository.addProtectedArea(player, protectedArea);
        this.messages.send((CommandSender)player, "&bProtected Area added", this.messages.prefixProtect);
    }

    public void deleteProtectedArea(Player player, String name) {
        Optional<ProtectedArea> protectedArea = this.protectedAreaRepository.findByName(name);
        if (!protectedArea.isPresent()) {
            throw new BusinessException("&bCannot delete area. No area with name [" + name + "] found", this.messages.prefixProtect);
        }
        this.protectedAreaRepository.deleteProtectedArea(protectedArea.get().getId());
        Optional<ProtectedArea> first = this.getAllProtectedAreas().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (first.isPresent()) {
            this.getAllProtectedAreas().remove(first.get());
            this.messages.send((CommandSender)player, "&bProtected Area deleted", this.messages.prefixProtect);
        }
    }

    public void deleteProtectedArea(Player player, int id) {
        Optional<ProtectedArea> protectedArea = this.protectedAreaRepository.findById(id);
        if (!protectedArea.isPresent()) {
            throw new BusinessException("&bCannot delete area. No area with id [" + id + "] found", this.messages.prefixProtect);
        }
        this.protectedAreaRepository.deleteProtectedArea(id);
        Optional<ProtectedArea> first = this.getAllProtectedAreas().stream().filter(p -> p.getName().equals(((ProtectedArea)protectedArea.get()).getName())).findFirst();
        if (first.isPresent()) {
            this.getAllProtectedAreas().remove(first.get());
            this.messages.send((CommandSender)player, "&bProtected Area deleted", this.messages.prefixProtect);
        }
    }

    public List<ProtectedArea> getAllProtectedAreas() {
        if (this.protectedAreas == null) {
            this.protectedAreas = Collections.synchronizedList(this.protectedAreaRepository.getProtectedAreas());
        }
        return this.protectedAreas;
    }

    public List<ProtectedArea> getAllProtectedAreasPaginated(int offset, int amount) {
        return this.protectedAreaRepository.getProtectedAreasPaginated(offset, amount);
    }

    public ProtectedArea getById(int protectedAreaId) {
        return this.protectedAreaRepository.findById(protectedAreaId).orElseThrow(() -> new BusinessException("&CNo area with id [" + protectedAreaId + "] found", this.messages.prefixProtect));
    }
}

