/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.playernotes.gui.cmd;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNote;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNoteService;
import net.shortninja.staffplus.core.domain.staff.playernotes.gui.cmd.PlayerNoteFiltersMapper;
import net.shortninja.staffplusplus.playernotes.PlayerNoteFilters;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:notes", permissions={"permissions:player-notes.view"}, description="View a player's notes", usage="[player]", playerRetrievalStrategy=PlayerRetrievalStrategy.OPTIONAL_BOTH)
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class NotesCmd
extends AbstractCmd {
    private static final String LIST_PARAM = "-l";
    private final PlayerNoteService playerNoteService;
    private final BukkitUtils bukkitUtils;
    private final GuiActionService guiActionService;
    private final PlayerManager playerManager;
    private final PlayerNoteFiltersMapper playerNoteFiltersMapper;

    public NotesCmd(PermissionHandler permissionHandler, Messages messages, CommandService commandService, PlayerNoteService playerNoteService, BukkitUtils bukkitUtils, GuiActionService guiActionService, PlayerManager playerManager, PlayerNoteFiltersMapper playerNoteFiltersMapper) {
        super(messages, permissionHandler, commandService);
        this.playerNoteService = playerNoteService;
        this.bukkitUtils = bukkitUtils;
        this.guiActionService = guiActionService;
        this.playerManager = playerManager;
        this.playerNoteFiltersMapper = playerNoteFiltersMapper;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        if (!(sender instanceof Player) || optionalParameters.containsKey(LIST_PARAM)) {
            PlayerNoteFilters.PlayerNoteFiltersBuilder playerNoteFiltersBuilder = new PlayerNoteFilters.PlayerNoteFiltersBuilder();
            optionalParameters.forEach((k, v) -> this.playerNoteFiltersMapper.map(k.substring(1), (String)v, playerNoteFiltersBuilder));
            if (targetPlayer != null) {
                playerNoteFiltersBuilder.target(targetPlayer);
            }
            this.bukkitUtils.runTaskAsync(sender, () -> this.listNotes(sender, this.playerNoteService.findPlayerNotes(sender, playerNoteFiltersBuilder.build(), 0, 100)));
        } else {
            GuiActionBuilder guiActionBuilder = GuiActionBuilder.builder().action("player-notes/view/overview");
            optionalParameters.forEach((key, value) -> guiActionBuilder.param(key.substring(1), (String)value));
            if (targetPlayer != null) {
                guiActionBuilder.param("target", targetPlayer.getUsername());
            }
            this.guiActionService.executeAction((Player)sender, guiActionBuilder.build());
        }
        return true;
    }

    @Override
    protected List<String> getOptionalParameters() {
        List<String> filterKeys = this.playerNoteFiltersMapper.getFilterKeys().stream().map(k -> "-" + k).collect(Collectors.toList());
        filterKeys.add(LIST_PARAM);
        return filterKeys;
    }

    private void listNotes(CommandSender sender, List<PlayerNote> notes) {
        for (String message : this.messages.noteListStart) {
            this.messages.send(sender, message.replace("%longline%", this.messages.LONG_LINE), message.contains("%longline%") ? "" : this.messages.prefixGeneral);
        }
        int notesSize = notes.size();
        for (int i = 0; i < notesSize; ++i) {
            if (notes.get(i).isPrivateNote()) {
                this.messages.send(sender, this.messages.noteListEntryPrivate.replace("%count%", Integer.toString(i + 1)).replace("%note%", notes.get(i).getNote()), this.messages.prefixGeneral);
                continue;
            }
            this.messages.send(sender, this.messages.noteListEntry.replace("%count%", Integer.toString(i + 1)).replace("%note%", notes.get(i).getNote()), this.messages.prefixGeneral);
        }
        for (String message : this.messages.noteListEnd) {
            this.messages.send(sender, message.replace("%longline%", this.messages.LONG_LINE), message.contains("%longline%") ? "" : this.messages.prefixGeneral);
        }
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Arrays.stream(args).filter(a -> !a.startsWith("-")).findFirst();
    }

    @Override
    protected List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (currentArg.startsWith("-")) {
            return this.playerNoteFiltersMapper.getFilterKeys().stream().map(k -> "-" + k + "=").collect(Collectors.toList());
        }
        return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
    }
}

