/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.playernotes.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParams;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNote;
import net.shortninja.staffplus.core.domain.staff.playernotes.PlayerNoteService;
import net.shortninja.staffplus.core.domain.staff.playernotes.gui.cmd.PlayerNoteFiltersMapper;
import net.shortninja.staffplusplus.playernotes.PlayerNoteFilters;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class PlayerNotesGuiController {
    @ConfigProperty(value="permissions:player-notes.create")
    private String permissionCreateNote;
    @ConfigProperty(value="permissions:player-notes.create-private")
    private String permissionCreatePrivateNote;
    @ConfigProperty(value="permissions:player-notes.delete")
    private String permissionDelete;
    @ConfigProperty(value="permissions:player-notes.delete-other")
    private String permissionDeleteOther;
    private static final int PAGE_SIZE = 45;
    private final PlayerManager playerManager;
    private final PlayerNoteService playerNoteService;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;
    private final PlayerNoteFiltersMapper playerNoteFiltersMapper;
    private final PermissionHandler permissionHandler;

    public PlayerNotesGuiController(PlayerManager playerManager, PlayerNoteService playerNoteService, Messages messages, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils, PlayerNoteFiltersMapper playerNoteFiltersMapper, PermissionHandler permissionHandler) {
        this.playerManager = playerManager;
        this.playerNoteService = playerNoteService;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
        this.playerNoteFiltersMapper = playerNoteFiltersMapper;
        this.permissionHandler = permissionHandler;
    }

    @GuiAction(value="player-notes/view/overview")
    public AsyncGui<GuiTemplate> getNoteOverview(Player player, @GuiParam(value="page", defaultValue="0") int page, @GuiParams Map<String, String> allParams) {
        return AsyncGui.async(() -> {
            PlayerNoteFilters.PlayerNoteFiltersBuilder playerNoteFiltersBuilder = new PlayerNoteFilters.PlayerNoteFiltersBuilder();
            allParams.forEach((k, v) -> this.playerNoteFiltersMapper.map((String)k, (String)v, playerNoteFiltersBuilder));
            List<PlayerNote> allPlayerNotes = this.playerNoteService.findPlayerNotes((CommandSender)player, playerNoteFiltersBuilder.build(), 45 * page, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "&bNote overview");
            params.put("notes", allPlayerNotes);
            return GuiTemplate.template("gui/player-notes/note-overview.ftl", params);
        });
    }

    @GuiAction(value="player-notes/create")
    public void createNote(Player staff, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer sppStaff = this.playerManager.getOnlinePlayer(staff.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        SppPlayer targetPlayer = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        PlayerSession playerSession = this.sessionManager.get(staff);
        this.messages.send((CommandSender)staff, this.messages.typeInput, this.messages.prefixGeneral);
        playerSession.setChatAction((player, input) -> this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            this.playerNoteService.createNote(sppStaff, input, targetPlayer, false);
            this.messages.send((CommandSender)player, this.messages.inputAccepted, this.messages.prefixGeneral);
        }));
    }

    @GuiAction(value="player-notes/delete")
    public AsyncGui<GuiActionReturnType> createNote(Player staff, @GuiParam(value="noteId") int noteId) {
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(staff.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(staff.getName()));
            PlayerNote note = this.playerNoteService.getNote(noteId);
            this.permissionHandler.validate((CommandSender)staff, this.permissionDelete);
            if (!note.getNotedByUuid().equals(staff.getUniqueId())) {
                this.permissionHandler.validate((CommandSender)staff, this.permissionDeleteOther);
            }
            this.playerNoteService.deleteNote(sppPlayer, noteId);
            return GuiActionReturnType.BACK;
        });
    }
}

