/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.playernotes.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplusplus.playernotes.IPlayerNote;
import net.shortninja.staffplusplus.playernotes.PlayerNoteCreatedEvent;
import net.shortninja.staffplusplus.playernotes.PlayerNoteDeletedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@IocBukkitListener
public class PlayerNoteChatNotifier
implements Listener {
    @ConfigProperty(value="permissions:player-notes.notifications")
    private String permissionNoteNotifications;
    private final Messages messages;

    public PlayerNoteChatNotifier(Messages messages) {
        this.messages = messages;
    }

    @EventHandler
    public void onNoteCreated(PlayerNoteCreatedEvent event) {
        event.getSender().getCommandSender().ifPresent(s -> this.messages.send((CommandSender)s, this.replaceNotePlaceholders(event.getPlayerNote(), this.messages.noteAdded), this.messages.prefixGeneral));
        if (!event.getPlayerNote().isPrivateNote()) {
            this.messages.sendGroupMessage(this.replaceNotePlaceholders(event.getPlayerNote(), this.messages.noteCreatedNotification), this.permissionNoteNotifications, this.messages.prefixPlayerNotes);
        }
    }

    @EventHandler
    public void onNoteDeleted(PlayerNoteDeletedEvent event) {
        if (event.getSender().isOnline()) {
            this.messages.send((CommandSender)event.getSender().getPlayer(), this.replaceNotePlaceholders(event.getPlayerNote(), this.messages.noteDeleted), this.messages.prefixGeneral);
        }
    }

    @NotNull
    private String replaceNotePlaceholders(IPlayerNote playerNote, String noteMessage) {
        return noteMessage.replace("%target%", playerNote.getTargetName()).replace("%notedBy%", playerNote.getNotedByName()).replace("%noteId%", playerNote.getId().toString()).replace("%note%", playerNote.getNote());
    }
}

