/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.time.TimeUnit;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.gui.cmd.AbstractMuteCmd;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:tempmute", description="Temporary mute a player", usage="[player] [amount] [unit] [reason] [-soft]", delayable=true, playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH, permissions={"permissions:tempmute"}, async=true)
@IocBean(conditionalOnProperty="mute-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class TempMuteCmd
extends AbstractMuteCmd {
    private final BukkitUtils bukkitUtils;

    public TempMuteCmd(PermissionHandler permissionHandler, Messages messages, MuteService muteService, CommandService commandService, PlayerManager playerManager, MuteConfiguration muteConfiguration, BukkitUtils bukkitUtils) {
        super(permissionHandler, messages, muteService, commandService, playerManager, muteConfiguration);
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (!JavaUtils.isInteger(args[1])) {
            throw new BusinessException(this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()));
        }
        int amount = Integer.parseInt(args[1]);
        String timeUnit = args[2];
        String reason = JavaUtils.compileWords(args, 3);
        this.bukkitUtils.runTaskAsync(sender, () -> this.muteService.tempMute(sender, player, TimeUnit.getDuration(timeUnit, amount), reason, this.isSoftMute(optionalParameters)));
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 4;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    protected boolean canBypass(Player player) {
        return this.permissionHandler.has(player, this.muteConfiguration.permissionMuteByPass);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Stream.of("5", "10", "15", "20").filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Arrays.stream(TimeUnit.values()).map(Enum::name).filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

