/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui.cmd;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.gui.MuteChatNotifier;
import net.shortninja.staffplusplus.mute.IMute;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@IocBukkitListener(conditionalOnProperty="mute-module.enabled=true")
public class MuteCommandInterceptor
implements Listener {
    private final OnlineSessionsManager sessionManager;
    private final MuteConfiguration muteConfiguration;
    private final MuteService muteService;
    private final BukkitUtils bukkitUtils;
    private final MuteChatNotifier muteChatNotifier;

    public MuteCommandInterceptor(OnlineSessionsManager sessionManager, MuteConfiguration muteConfiguration, MuteService muteService, BukkitUtils bukkitUtils, MuteChatNotifier muteChatNotifier) {
        this.sessionManager = sessionManager;
        this.muteConfiguration = muteConfiguration;
        this.muteService = muteService;
        this.bukkitUtils = bukkitUtils;
        this.muteChatNotifier = muteChatNotifier;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void interceptCommands(PlayerCommandPreprocessEvent event) {
        PlayerSession playerSession = this.sessionManager.get(event.getPlayer());
        if (!playerSession.isMuted()) {
            return;
        }
        String command = event.getMessage().toLowerCase();
        boolean executedBlockedCommand = this.muteConfiguration.blockedCommands.stream().anyMatch(c -> command.startsWith("/" + c));
        if (executedBlockedCommand) {
            this.bukkitUtils.runTaskAsync((CommandSender)event.getPlayer(), () -> this.muteService.getMuteByMutedUuid(event.getPlayer().getUniqueId()).ifPresent(mute -> this.muteChatNotifier.notifyPlayerMuted((IMute)mute, event.getPlayer())));
            event.setCancelled(true);
        }
    }
}

