/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.time.TimeUnit;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:extendmute", description="Extend mute of a player", usage="[player] [amount] [unit]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH, permissions={"permissions:extendmute"}, async=true)
@IocBean(conditionalOnProperty="mute-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ExtendMuteCmd
extends AbstractCmd {
    private final PermissionHandler permissionHandler;
    private final MuteConfiguration muteConfiguration;
    private final MuteService muteService;
    private final PlayerManager playerManager;

    public ExtendMuteCmd(PermissionHandler permissionHandler, Messages messages, MuteConfiguration muteConfiguration, MuteService muteService, CommandService commandService, PlayerManager playerManager) {
        super(messages, permissionHandler, commandService);
        this.permissionHandler = permissionHandler;
        this.muteConfiguration = muteConfiguration;
        this.muteService = muteService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (!JavaUtils.isInteger(args[1])) {
            throw new BusinessException(this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()));
        }
        int amount = Integer.parseInt(args[1]);
        String timeUnit = args[2];
        this.muteService.extendMute(sender, player, TimeUnit.getDuration(timeUnit, amount));
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 3;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    protected boolean canBypass(Player player) {
        return this.permissionHandler.has(player, this.muteConfiguration.permissionMuteByPass);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Stream.of("5", "10", "15", "20").filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Stream.of(TimeUnit.YEAR.name(), TimeUnit.MONTH.name(), TimeUnit.WEEK.name(), TimeUnit.DAY.name(), TimeUnit.HOUR.name(), TimeUnit.MINUTE.name()).filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

