/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.database.MuteRepository;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class MuteGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final Messages messages;
    private final MuteService muteService;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;
    private final PlayerManager playerManager;
    private final MuteRepository muteRepository;
    @ConfigProperty(value="%lang%:gui.mutes.my-mutes.title")
    private String myMytesGuiTitle;

    public MuteGuiController(Messages messages, MuteService muteService, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils, PlayerManager playerManager, MuteRepository muteRepository) {
        this.messages = messages;
        this.muteService = muteService;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
        this.playerManager = playerManager;
        this.muteRepository = muteRepository;
    }

    @GuiAction(value="manage-mutes/view/all-active")
    public AsyncGui<GuiTemplate> getMutedPlayersOverview(@GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="page", defaultValue="0") int page) {
        SppPlayer target = null;
        if (StringUtils.isNotBlank(targetPlayerName)) {
            target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        }
        SppPlayer finalTarget = target;
        return AsyncGui.async(() -> {
            List<Mute> allPaged = this.getMutes(finalTarget, page);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "&bActive mutes");
            params.put("mutes", allPaged);
            params.put("guiId", "active-mutes-overview");
            return GuiTemplate.template("gui/mutes/mute-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-mutes/view/my-mutes")
    public AsyncGui<GuiTemplate> myMutesOverview(Player player, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<Mute> allPaged = this.muteRepository.getMyMutes(player.getUniqueId(), page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", this.myMytesGuiTitle);
            params.put("mutes", allPaged);
            params.put("guiId", "my-mutes-overview");
            return GuiTemplate.template("gui/mutes/mute-overview.ftl", params);
        });
    }

    private List<Mute> getMutes(SppPlayer target, int page) {
        if (target == null) {
            return this.muteService.getAllPaged(page * 45, 45);
        }
        return this.muteRepository.getMutesForPlayerPaged(target.getId(), page * 45, 45);
    }

    @GuiAction(value="manage-mutes/view/history")
    public AsyncGui<GuiTemplate> getMutedPlayersOverview(@GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        return AsyncGui.async(() -> {
            List<Mute> allPaged = this.muteRepository.getMutesForPlayerPaged(target.getId(), page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "Mute History for: &C" + target.getUsername());
            params.put("mutes", allPaged);
            params.put("guiId", "history-mutes-overview");
            return GuiTemplate.template("gui/mutes/mute-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-mutes/view/detail")
    public AsyncGui<GuiTemplate> getMuteDetailView(@GuiParam(value="muteId") int muteId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("mute", this.muteService.getById(muteId));
            return GuiTemplate.template("gui/mutes/manage-mute.ftl", params);
        });
    }

    @GuiAction(value="manage-mutes/unmute")
    public void unmute(Player player, @GuiParam(value="muteId") int muteId) {
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to unmute this player", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6Type your reason for unmuting this player in chat", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel the unmute ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        SppPlayer target = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, message) -> {
            if (message.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled unmuting this player", this.messages.prefixGeneral);
                return;
            }
            this.bukkitUtils.runTaskAsync((CommandSender)player1, () -> this.muteService.unmute(target, muteId, message));
        });
    }
}

