/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.MuteMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplusplus.mute.IMute;
import net.shortninja.staffplusplus.mute.MuteEvent;
import net.shortninja.staffplusplus.mute.MuteExtensionEvent;
import net.shortninja.staffplusplus.mute.MuteReductionEvent;
import net.shortninja.staffplusplus.mute.UnmuteEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class MuteChatNotifier
implements Listener {
    private final Messages messages;
    private final MuteConfiguration muteConfiguration;
    private final PlayerManager playerManager;

    public MuteChatNotifier(Messages messages, MuteConfiguration muteConfiguration, PlayerManager playerManager) {
        this.messages = messages;
        this.muteConfiguration = muteConfiguration;
        this.playerManager = playerManager;
    }

    @EventHandler
    public void onMuteEvent(MuteEvent event) {
        IMute mute = event.getMute();
        if (mute.getEndTimestamp() == null) {
            String message = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.permanentMuted, mute);
            this.messages.sendGroupMessage(message, this.muteConfiguration.staffNotificationPermission, this.messages.prefixGeneral);
        } else {
            String message = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.tempMuted, mute);
            this.messages.sendGroupMessage(message, this.muteConfiguration.staffNotificationPermission, this.messages.prefixGeneral);
        }
    }

    @EventHandler
    public void notifyUnmute(UnmuteEvent event) {
        IMute mute = event.getMute();
        String unmuteMessage = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.unmuted, mute);
        this.messages.sendGroupMessage(unmuteMessage, this.muteConfiguration.staffNotificationPermission, this.messages.prefixGeneral);
    }

    @EventHandler
    public void notifyMuteExtension(MuteExtensionEvent event) {
        IMute mute = event.getMute();
        String message = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.muteExtended, mute).replace("%extensionDuration%", JavaUtils.toHumanReadableDuration(event.getExtensionDuration()));
        this.messages.send(event.getExecutor(), message, this.messages.prefixGeneral);
    }

    @EventHandler
    public void notifyMuteReduction(MuteReductionEvent event) {
        IMute mute = event.getMute();
        String message = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.muteReduced, mute).replace("%reductionDuration%", JavaUtils.toHumanReadableDuration(event.getReductionDuration()));
        this.messages.send(event.getExecutor(), message, this.messages.prefixGeneral);
    }

    public void notifyPlayerMuted(IMute mute, Player player) {
        if (!mute.isSoftMute()) {
            String message = MuteMessageStringUtil.replaceMutePlaceholders(this.messages.muted, mute);
            this.messages.send((CommandSender)player, message, this.messages.prefixGeneral);
        }
    }
}

