/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.gui;

import java.util.Optional;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.gui.MuteChatNotifier;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean
@IocMultiProvider(value={ChatInterceptor.class})
public class MuteChatInterceptor
implements ChatInterceptor {
    private final OnlineSessionsManager sessionManager;
    private final MuteService muteService;
    private final MuteChatNotifier muteChatNotifier;

    public MuteChatInterceptor(OnlineSessionsManager sessionManager, MuteService muteService, MuteChatNotifier muteChatNotifier) {
        this.sessionManager = sessionManager;
        this.muteService = muteService;
        this.muteChatNotifier = muteChatNotifier;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        PlayerSession playerSession = this.sessionManager.get(event.getPlayer());
        if (!playerSession.isMuted()) {
            return false;
        }
        Optional<Mute> mute = this.muteService.getMuteByMutedUuid(event.getPlayer().getUniqueId());
        if (!mute.isPresent()) {
            return false;
        }
        this.muteChatNotifier.notifyPlayerMuted(mute.get(), event.getPlayer());
        if (mute.get().isSoftMute()) {
            event.getRecipients().removeIf(p -> p.getUniqueId() != event.getPlayer().getUniqueId());
            return false;
        }
        return true;
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

