/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.appeals.gui;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.List;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.appeals.MuteAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.database.MuteRepository;
import net.shortninja.staffplusplus.appeals.AppealApprovedEvent;
import net.shortninja.staffplusplus.appeals.AppealRejectedEvent;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.AppealedEvent;
import net.shortninja.staffplusplus.appeals.IAppeal;
import net.shortninja.staffplusplus.mute.appeals.MuteAppealApprovedEvent;
import net.shortninja.staffplusplus.mute.appeals.MuteAppealRejectedEvent;
import net.shortninja.staffplusplus.mute.appeals.MuteAppealedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class MuteAppealChatNotifier
implements Listener {
    @ConfigProperty(value="commands:mutes.manage.gui")
    public List<String> commandManageMutesGui;
    private final Messages messages;
    private final MuteAppealConfiguration muteAppealConfiguration;
    private final PlayerManager playerManager;
    private final MuteRepository muteRepository;

    public MuteAppealChatNotifier(Messages messages, MuteAppealConfiguration muteAppealConfiguration, PlayerManager playerManager, MuteRepository muteRepository) {
        this.messages = messages;
        this.muteAppealConfiguration = muteAppealConfiguration;
        this.playerManager = playerManager;
        this.muteRepository = muteRepository;
    }

    @EventHandler
    public void handleAppealedEvent(AppealedEvent appealedEvent) {
        if (appealedEvent.getAppealable().getType() != AppealableType.MUTE) {
            return;
        }
        Mute mute = (Mute)appealedEvent.getAppealable();
        mute.getAppeal().ifPresent(appeal -> {
            this.playerManager.getOnlinePlayer(appeal.getAppealerUuid()).ifPresent(appealer -> {
                this.sendAppealedMessageToStaff(mute, appealer.getPlayer());
                String message = this.messages.appealCreated.replace("%reason%", appeal.getReason());
                this.messages.send((CommandSender)appealer.getPlayer(), message, this.messages.prefixGeneral);
            });
            BukkitUtils.sendEvent(new MuteAppealedEvent(mute));
        });
    }

    @EventHandler
    public void handleAppealApproved(AppealApprovedEvent appealApprovedEvent) {
        if (appealApprovedEvent.getAppeal().getType() != AppealableType.MUTE) {
            return;
        }
        IAppeal appeal = appealApprovedEvent.getAppeal();
        Mute mute = this.muteRepository.getMute(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No mute found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealApproved);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealApprove);
        BukkitUtils.sendEvent(new MuteAppealApprovedEvent(appeal, mute));
    }

    @EventHandler
    public void handleAppealRejected(AppealRejectedEvent appealRejectedEvent) {
        if (appealRejectedEvent.getAppeal().getType() != AppealableType.MUTE) {
            return;
        }
        IAppeal appeal = appealRejectedEvent.getAppeal();
        Mute mute = this.muteRepository.getMute(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No mute found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealRejected);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealReject);
        BukkitUtils.sendEvent(new MuteAppealRejectedEvent(appeal, mute));
    }

    private void sendMessageToPlayer(UUID appealerUuid, String appealApproved) {
        this.playerManager.getOnlinePlayer(appealerUuid).ifPresent(sppPlayer -> this.messages.send((CommandSender)sppPlayer.getPlayer(), appealApproved, this.messages.prefixGeneral));
    }

    private void sendAppealedMessageToStaff(Mute mute, Player appealer) {
        String manageMutesCommand = this.commandManageMutesGui.get(0) + " " + mute.getTargetName();
        JSONMessage jsonMessage = JavaUtils.buildClickableMessage(appealer.getName() + " has appealed a mute", "View mutes!", "Click to open the mutes view", manageMutesCommand, true);
        this.messages.sendGroupMessage(jsonMessage, this.muteAppealConfiguration.permissionNotifications);
    }
}

