/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute.appeals;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.common.utils.Validator;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.appeals.Appeal;
import net.shortninja.staffplus.core.domain.staff.appeals.AppealService;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.appeals.MuteAppealConfiguration;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class MuteAppealGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final AppealService appealService;
    private final MuteService muteService;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;
    private final MuteAppealConfiguration muteAppealConfiguration;
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;

    public MuteAppealGuiController(AppealService appealService, MuteService muteService, Messages messages, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils, MuteAppealConfiguration muteAppealConfiguration, PermissionHandler permissionHandler, PlayerManager playerManager) {
        this.appealService = appealService;
        this.muteService = muteService;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
        this.muteAppealConfiguration = muteAppealConfiguration;
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
    }

    @GuiAction(value="manage-mute-appeals/view/detail")
    public AsyncGui<GuiTemplate> getAppealDetail(@GuiParam(value="appealId") int appealId) {
        return AsyncGui.async(() -> {
            Appeal appeal = this.appealService.getAppeal(appealId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appeal", appeal);
            return GuiTemplate.template("gui/mutes/appeal-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-mute-appeals/view/create/reason-select")
    public GuiTemplate getCreateAppealReasonSelectView(@GuiParam(value="muteId") int muteId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", "manage-mute-appeals/create?muteId=" + muteId);
        params.put("reasons", this.muteAppealConfiguration.appealReasons);
        return GuiTemplate.template("gui/appeals/appeal-reason-select.ftl", params);
    }

    @GuiAction(value="manage-mute-appeals/view/create/reason-chat")
    public void getCreateAppealReasonChatView(Player player, @GuiParam(value="muteId") int muteId) {
        Mute mute = this.muteService.getActiveById(muteId);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to appeal this mute", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6            Type your appeal reason in chat", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         Type \"cancel\" to cancel appealing ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, input) -> {
            if (input.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled your appeal", this.messages.prefixGeneral);
                return;
            }
            SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
            Validator.validator(player).validateAnyPermission(this.muteAppealConfiguration.createAppealPermission).validateNotEmpty(input, "Reason for appeal can not be empty");
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.addAppeal(sppPlayer, mute, input));
        });
    }

    @GuiAction(value="manage-mute-appeals/create")
    public void createAppeal(Player player, @GuiParam(value="muteId") int muteId, @GuiParam(value="reason") String reason) {
        Validator.validator(player).validateAnyPermission(this.muteAppealConfiguration.createAppealPermission).validateNotEmpty(reason, "Reason for appeal can not be empty");
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Mute mute = this.muteService.getActiveById(muteId);
            this.appealService.addAppeal(sppPlayer, mute, reason);
        });
    }

    @GuiAction(value="manage-mutes/view/appealed-mutes")
    public AsyncGui<GuiTemplate> appealedMutesOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<Mute> mutes = this.muteService.getAppealedMutes(page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("mutes", mutes);
            return GuiTemplate.template("gui/mutes/appealed-mutes-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-mute-appeals/approve")
    public void approveAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permissionHandler.validate((CommandSender)player, this.muteAppealConfiguration.approveAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.muteAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6       You have chosen to approve this appeal", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to approve the appeal", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6      Type \"cancel\" to cancel approving the appeal ", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixGeneral);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled approving this appeal", this.messages.prefixGeneral);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.approveAppeal(sppPlayer, appealId, message, AppealableType.MUTE));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.approveAppeal(sppPlayer, appealId, AppealableType.MUTE));
        }
    }

    @GuiAction(value="manage-mute-appeals/reject")
    public void rejectAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permissionHandler.validate((CommandSender)player, this.muteAppealConfiguration.rejectAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.muteAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6        You have chosen to reject this appeal", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to reject the appeal", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel closing the appeal ", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixGeneral);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled rejecting this appeal", this.messages.prefixGeneral);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.rejectAppeal(sppPlayer, appealId, message, AppealableType.MUTE));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.rejectAppeal(sppPlayer, appealId, AppealableType.MUTE));
        }
    }
}

