/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.MuteService;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplusplus.session.IPlayerSession;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

@IocBean
public class MuteSessionTask
extends BukkitRunnable {
    public static final int DELAY = 200;
    private final Messages messages;
    private final OnlineSessionsManager onlineSessionsManager;
    private final MuteService muteService;
    private final MuteConfiguration muteConfiguration;
    private final PlayerManager playerManager;

    public MuteSessionTask(Messages messages, OnlineSessionsManager onlineSessionsManager, MuteService muteService, MuteConfiguration muteConfiguration, PlayerManager playerManager) {
        this.messages = messages;
        this.onlineSessionsManager = onlineSessionsManager;
        this.muteService = muteService;
        this.muteConfiguration = muteConfiguration;
        this.playerManager = playerManager;
        this.runTaskTimerAsynchronously((Plugin)StaffPlusPlus.get(), 200L, 200L);
    }

    public void run() {
        if (!this.muteConfiguration.muteEnabled) {
            return;
        }
        ArrayList<Player> onlinePlayers = new ArrayList<Player>(this.playerManager.getOnlinePlayers());
        List<Mute> activeMutes = this.muteService.getAllActiveMutes(onlinePlayers);
        List<OnlinePlayerSession> mutedSessions = this.onlineSessionsManager.getAll().stream().filter(IPlayerSession::isMuted).collect(Collectors.toList());
        mutedSessions.forEach(mutedSession -> {
            Optional<Player> onlinePlayer = this.getPlayer(onlinePlayers, (OnlinePlayerSession)mutedSession);
            if (onlinePlayer.isPresent()) {
                Optional<Mute> activeMute = activeMutes.stream().filter(mute -> mute.getTargetUuid().equals(((Player)onlinePlayer.get()).getUniqueId())).findFirst();
                mutedSession.setMuted(activeMute.isPresent());
                if (!activeMute.isPresent()) {
                    this.muteService.getLastMute(onlinePlayer.get().getUniqueId()).filter(m -> !m.isSoftMute()).ifPresent(mute -> this.messages.send((CommandSender)((Player)onlinePlayer.get()).getPlayer(), this.messages.muteExpired, this.messages.prefixGeneral));
                }
            }
        });
    }

    @NotNull
    private Optional<Player> getPlayer(ArrayList<Player> onlinePlayers, OnlinePlayerSession mutedSession) {
        return onlinePlayers.stream().filter(p -> p.getUniqueId() == mutedSession.getUuid()).findFirst();
    }
}

