/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionInfo;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionProvider;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.config.InfractionsConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.Mute;
import net.shortninja.staffplus.core.domain.staff.mute.config.MuteConfiguration;
import net.shortninja.staffplus.core.domain.staff.mute.database.MuteRepository;
import net.shortninja.staffplusplus.mute.MuteEvent;
import net.shortninja.staffplusplus.mute.MuteExtensionEvent;
import net.shortninja.staffplusplus.mute.MuteFilters;
import net.shortninja.staffplusplus.mute.MuteReductionEvent;
import net.shortninja.staffplusplus.mute.UnmuteEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={InfractionProvider.class})
public class MuteService
implements InfractionProvider,
net.shortninja.staffplusplus.mute.MuteService {
    private static final String LIMIT = ".limit";
    private final PermissionHandler permission;
    private final MuteRepository muteRepository;
    private final MuteConfiguration muteConfiguration;
    private final InfractionsConfiguration infractionsConfiguration;

    public MuteService(PermissionHandler permission, MuteRepository muteRepository, MuteConfiguration muteConfiguration, InfractionsConfiguration infractionsConfiguration) {
        this.permission = permission;
        this.muteRepository = muteRepository;
        this.muteConfiguration = muteConfiguration;
        this.infractionsConfiguration = infractionsConfiguration;
    }

    public void permMute(CommandSender issuer, SppPlayer playerToMute, String reason, boolean softMute) {
        this.mute(issuer, playerToMute, reason, null, softMute);
    }

    public void tempMute(CommandSender issuer, SppPlayer playerToMute, Long durationInMillis, String reason, boolean softMute) {
        this.checkDurationPermission(issuer, durationInMillis);
        this.mute(issuer, playerToMute, reason, durationInMillis, softMute);
    }

    public Optional<Mute> getMuteByMutedUuid(UUID playerUuid) {
        return this.muteRepository.findActiveMute(playerUuid);
    }

    public Mute getById(int muteId) {
        return this.muteRepository.getMute(muteId).orElseThrow(() -> new BusinessException("No mute found with this id"));
    }

    public Mute getActiveById(int muteId) {
        return this.muteRepository.findActiveMute(muteId).orElseThrow(() -> new BusinessException("No mute found with this id"));
    }

    public List<Mute> getAllPaged(int offset, int amount) {
        return this.muteRepository.getActiveMutes(offset, amount);
    }

    @Override
    public long getMuteCount(MuteFilters muteFilters) {
        return this.muteRepository.getMuteCount(muteFilters);
    }

    public List<Mute> getAllActiveMutes(List<Player> players) {
        if (players.isEmpty()) {
            return Collections.emptyList();
        }
        return this.muteRepository.getAllActiveMutes(players.stream().map(p -> p.getUniqueId().toString()).collect(Collectors.toList()));
    }

    public void extendMute(CommandSender sender, SppPlayer player, long duration) {
        Mute mute = this.getMuteByMutedUuid(player.getId()).orElseThrow(() -> new BusinessException("&CThis player isn't muted"));
        if (mute.getEndDate() == null) {
            throw new BusinessException("The player is permanently muted. Cannot extend mute");
        }
        long newDuration = mute.getEndTimestamp() - System.currentTimeMillis() + duration;
        this.permission.validateDuration(sender, this.muteConfiguration.permissionTempmutePlayer + LIMIT, newDuration);
        this.permission.validateDuration(sender, this.muteConfiguration.permissionExtendMutePlayer + LIMIT, duration);
        this.muteRepository.setMuteDuration(mute.getId(), mute.getEndTimestamp() + duration);
        Mute updatedMute = this.getActiveById(mute.getId());
        BukkitUtils.sendEvent(new MuteExtensionEvent(updatedMute, duration, sender));
    }

    public void reduceMute(CommandSender sender, SppPlayer player, long duration) {
        Mute mute = this.getMuteByMutedUuid(player.getId()).orElseThrow(() -> new BusinessException("&CThis player isn't muted"));
        if (mute.getEndDate() == null) {
            throw new BusinessException("The player is permanently muted. Cannot reduce mute");
        }
        this.permission.validateDuration(sender, this.muteConfiguration.permissionReduceMutePlayer + LIMIT, duration);
        this.muteRepository.setMuteDuration(mute.getId(), mute.getEndTimestamp() - duration);
        Mute updatedMute = this.getActiveById(mute.getId());
        BukkitUtils.sendEvent(new MuteReductionEvent(updatedMute, duration, sender));
    }

    public void unmute(CommandSender issuer, SppPlayer playerToUnmute, String reason) {
        Mute mute = this.muteRepository.findActiveMute(playerToUnmute.getId()).orElseThrow(() -> new BusinessException("&CCannot unmute, this user is not muted"));
        mute.setUnmutedByName(issuer instanceof Player ? issuer.getName() : "Console");
        mute.setUnmutedByUuid(issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID);
        mute.setUnmuteReason(reason);
        this.unmute(mute);
    }

    public void unmute(SppPlayer issuer, int muteId, String reason) {
        Mute mute = this.muteRepository.findActiveMute(muteId).orElseThrow(() -> new BusinessException("&CCannot unmute, this user is not muted"));
        mute.setUnmutedByName(issuer.getUsername());
        mute.setUnmutedByUuid(issuer.getId());
        mute.setUnmuteReason(reason);
        this.unmute(mute);
    }

    public List<Mute> getAppealedMutes(int offset, int amount) {
        return this.muteRepository.getAppealedMutes(offset, amount);
    }

    private void mute(CommandSender issuer, SppPlayer playerToMute, String reason, Long durationInMillis, boolean softMute) {
        if (playerToMute.isOnline() && this.permission.has(playerToMute.getPlayer(), this.muteConfiguration.permissionMuteByPass)) {
            throw new BusinessException("&CThis player bypasses being muted");
        }
        this.muteRepository.findActiveMute(playerToMute.getId()).ifPresent(e -> {
            throw new BusinessException("&CCannot mute this player, the player is already muted");
        });
        String issuerName = issuer instanceof Player ? issuer.getName() : "Console";
        UUID issuerUuid = issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID;
        Long endDate = durationInMillis == null ? null : Long.valueOf(System.currentTimeMillis() + durationInMillis);
        Mute mute = new Mute(reason, endDate, issuerName, issuerUuid, playerToMute.getUsername(), playerToMute.getId(), softMute);
        mute.setId(this.muteRepository.addMute(mute));
        BukkitUtils.sendEvent(new MuteEvent(mute));
    }

    private void unmute(Mute mute) {
        this.muteRepository.update(mute);
        BukkitUtils.sendEvent(new UnmuteEvent(mute));
    }

    @Override
    public List<? extends Infraction> getInfractions(Player executor, UUID playerUUID) {
        if (!this.infractionsConfiguration.isShowMutes()) {
            return Collections.emptyList();
        }
        return this.muteRepository.getMutesForPlayer(playerUUID);
    }

    @Override
    public Optional<InfractionInfo> getInfractionsInfo() {
        if (!this.infractionsConfiguration.isShowMutes()) {
            return Optional.empty();
        }
        Map<UUID, List<String>> muteDurationByPlayer = this.muteRepository.getMuteDurationByPlayer().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList("&bTotal time muted: ", "&6" + JavaUtils.toHumanReadableDuration((Long)e.getValue()))));
        for (UUID permMutedPlayer : this.muteRepository.getAllPermanentMutedPlayers()) {
            muteDurationByPlayer.put(permMutedPlayer, Collections.singletonList("&CPermanently muted"));
        }
        return Optional.of(new InfractionInfo(InfractionType.MUTE, this.muteRepository.getCountByPlayer(), muteDurationByPlayer));
    }

    @Override
    public InfractionType getType() {
        return InfractionType.MUTE;
    }

    @Override
    public long getTotalMuteCount() {
        return this.muteRepository.getTotalCount();
    }

    @Override
    public long getActiveMuteCount() {
        return this.muteRepository.getActiveCount();
    }

    private void checkDurationPermission(CommandSender player, long durationProvided) {
        this.permission.validateDuration(player, this.muteConfiguration.permissionTempmutePlayer + LIMIT, durationProvided);
    }

    public Optional<Mute> getLastMute(UUID playerUuid) {
        return this.muteRepository.getLastMute(playerUuid);
    }
}

