/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.listeners;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class TeleportOnStaffMode
implements Listener {
    private final PlayerManager playerManager;
    private final ModeProvider modeProvider;
    private final Messages messages;

    public TeleportOnStaffMode(PlayerManager playerManager, ModeProvider modeProvider, Messages messages) {
        this.playerManager = playerManager;
        this.modeProvider = modeProvider;
        this.messages = messages;
    }

    @EventHandler
    public void teleportOnExit(ExitStaffModeEvent event) {
        this.playerManager.getOnlinePlayer(event.getPlayerUuid()).map(SppPlayer::getPlayer).ifPresent(player -> {
            GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode((Player)player, event.getMode());
            Optional<Location> previousLocation = event.getModeData().getPreviousLocation();
            if (modeConfiguration.isModeOriginalLocation() && previousLocation.isPresent()) {
                player.teleport(previousLocation.get().setDirection(player.getLocation().getDirection()));
                this.messages.send((CommandSender)player, this.messages.modeOriginalLocation, this.messages.prefixGeneral);
            }
            event.getTeleportToLocation().ifPresent(arg_0 -> ((Player)player).teleport(arg_0));
        });
    }
}

