/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.listeners;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.potioneffects.PotionEffectService;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.staffmode.EnterStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.IModeData;
import net.shortninja.staffplusplus.staffmode.SwitchStaffModeEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@IocBukkitListener
public class PlayerStateOnStaffMode
implements Listener {
    private final PlayerManager playerManager;
    private final ModeProvider modeProvider;
    private final Messages messages;
    private final PotionEffectService potionEffectService;

    public PlayerStateOnStaffMode(PlayerManager playerManager, ModeProvider modeProvider, Messages messages, PotionEffectService potionEffectService) {
        this.playerManager = playerManager;
        this.modeProvider = modeProvider;
        this.messages = messages;
        this.potionEffectService = potionEffectService;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onStaffMode(EnterStaffModeEvent event) {
        this.playerManager.getOnlinePlayer(event.getPlayerUuid()).map(SppPlayer::getPlayer).ifPresent(player -> {
            this.potionEffectService.removeAllPotionEffects((Player)player);
            this.messages.send((CommandSender)player, this.messages.modeStatus.replace("%status%", this.messages.enabled), this.messages.prefixGeneral);
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSwitchStaffMode(SwitchStaffModeEvent event) {
        this.playerManager.getOnlinePlayer(event.getPlayerUuid()).map(SppPlayer::getPlayer).ifPresent(player -> {
            GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode((Player)player, event.getToMode());
            this.potionEffectService.removeAllPotionEffects((Player)player);
            this.messages.send((CommandSender)player, "&eYou switched to staff mode &6" + modeConfiguration.getName(), this.messages.prefixGeneral);
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onExitMode(ExitStaffModeEvent event) {
        this.playerManager.getOnOrOfflinePlayer(event.getPlayerUuid()).map(SppPlayer::getPlayer).ifPresent(player -> {
            IModeData modeData = event.getModeData();
            player.setExp(modeData.getXp());
            player.setAllowFlight(modeData.hasFlight());
            player.setGameMode(modeData.getGameMode());
            player.setFireTicks(modeData.getFireTicks());
            this.potionEffectService.removeAllPotionEffects((Player)player);
            modeData.getPotionEffects().forEach(arg_0 -> ((Player)player).addPotionEffect(arg_0));
            this.messages.send((CommandSender)player, this.messages.modeStatus.replace("%status%", this.messages.disabled), this.messages.prefixGeneral);
        });
    }
}

