/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.listeners;

import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.nightvision.NightVisionService;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.staffmode.EnterStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.SwitchStaffModeEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@IocBukkitListener
public class NightVisionOnStaffMode
implements Listener {
    private final PlayerManager playerManager;
    private final ModeProvider modeProvider;
    private final NightVisionService nightVisionService;

    public NightVisionOnStaffMode(PlayerManager playerManager, ModeProvider modeProvider, NightVisionService nightVisionService) {
        this.playerManager = playerManager;
        this.modeProvider = modeProvider;
        this.nightVisionService = nightVisionService;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void nightVisionOnStaffMode(EnterStaffModeEvent event) {
        this.setNightVision(event.getPlayerUuid(), event.getMode());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void nightVisionOnStaffMode(SwitchStaffModeEvent event) {
        this.setNightVision(event.getPlayerUuid(), event.getToMode());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void nightVisionOnStaffMode(ExitStaffModeEvent event) {
        this.playerManager.getOnlinePlayer(event.getPlayerUuid()).ifPresent(player -> this.nightVisionService.turnOffNightVision("STAFF_MODE", player.getPlayer()));
    }

    private void setNightVision(UUID playerUuid, String toMode) {
        this.playerManager.getOnlinePlayer(playerUuid).ifPresent(player -> {
            GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode((SppPlayer)player, toMode);
            if (modeConfiguration.isNightVision()) {
                this.nightVisionService.turnOnNightVision("STAFF_MODE", player.getPlayer());
            }
        });
    }
}

