/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.item;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeItemsService;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModule;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.vanish.VanishModeConfiguration;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

@IocBukkitListener(conditionalOnProperty="vanish-module.enabled=true")
public class VanishItemUpdater
implements Listener {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final IProtocolService protocolService;
    private final VanishModeConfiguration vanishModeConfiguration;
    private final ModeProvider modeProvider;
    private final StaffModeItemsService staffModeItemsService;

    public VanishItemUpdater(PlayerSettingsRepository playerSettingsRepository, IProtocolService protocolService, Options options, ModeProvider modeProvider, StaffModeItemsService staffModeItemsService) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.protocolService = protocolService;
        this.vanishModeConfiguration = options.staffItemsConfiguration.getVanishModeConfiguration();
        this.modeProvider = modeProvider;
        this.staffModeItemsService = staffModeItemsService;
    }

    @EventHandler
    public void vanishOn(VanishOnEvent event) {
        this.resetVanishItem(event.getPlayer());
    }

    @EventHandler
    public void vanishOff(VanishOffEvent event) {
        this.resetVanishItem(event.getPlayer());
    }

    private void resetVanishItem(Player player) {
        PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (playerSettings.isInStaffMode()) {
            this.getVanishItemSlot(player).ifPresent(slot -> this.staffModeItemsService.setModuleItem(player, StaffModule.VANISH_MODULE, (int)slot));
        }
    }

    private Optional<Integer> getVanishItemSlot(Player player) {
        ItemStack[] contents = player.getInventory().getContents();
        int contentsLength = contents.length;
        for (int i = 0; i < contentsLength; ++i) {
            ItemStack item = contents[i];
            String nbtString = this.protocolService.getVersionProtocol().getNbtString(item);
            if (!this.vanishModeConfiguration.getIdentifier().equalsIgnoreCase(nbtString)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }
}

