/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeItemsService;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.handler.CpsHandler;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetType;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishService;
import net.shortninja.staffplusplus.session.IPlayerSession;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@IocBean
public class GadgetHandler {
    private static final Map<UUID, Integer> lastRandomTeleport = new HashMap<UUID, Integer>();
    @ConfigProperty(value="permissions:random-teleport-bypass")
    private String randomTeleportBypass;
    private final IProtocolService protocolService;
    private final PermissionHandler permission;
    private final Options options;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final PlayerSettingsRepository playerSettingsRepository;
    private final CpsHandler cpsHandler;
    private final VanishService vanishService;
    private final PlayerManager playerManager;
    private final GuiActionService guiActionService;
    private final BukkitUtils bukkitUtils;
    private final ModeProvider modeProvider;
    private final StaffModeItemsService staffModeItemsService;

    public GadgetHandler(IProtocolService protocolService, PermissionHandler permission, Options options, Messages messages, OnlineSessionsManager sessionManager, PlayerSettingsRepository playerSettingsRepository, CpsHandler cpsHandler, VanishService vanishService, PlayerManager playerManager, GuiActionService guiActionService, BukkitUtils bukkitUtils, ModeProvider modeProvider, StaffModeItemsService staffModeItemsService) {
        this.protocolService = protocolService;
        this.permission = permission;
        this.options = options;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.playerSettingsRepository = playerSettingsRepository;
        this.cpsHandler = cpsHandler;
        this.vanishService = vanishService;
        this.playerManager = playerManager;
        this.guiActionService = guiActionService;
        this.bukkitUtils = bukkitUtils;
        this.modeProvider = modeProvider;
        this.staffModeItemsService = staffModeItemsService;
    }

    public GadgetType getGadgetType(String value) {
        if (this.options.staffItemsConfiguration.getCompassModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.COMPASS;
        }
        if (this.options.staffItemsConfiguration.getRandomTeleportModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.RANDOM_TELEPORT;
        }
        if (this.options.staffItemsConfiguration.getVanishModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.VANISH;
        }
        if (this.options.staffItemsConfiguration.getGuiModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.GUI_HUB;
        }
        if (this.options.staffItemsConfiguration.getCounterModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.COUNTER;
        }
        if (this.options.staffItemsConfiguration.getFreezeModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.FREEZE;
        }
        if (this.options.staffItemsConfiguration.getCpsModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.CPS;
        }
        if (this.options.staffItemsConfiguration.getExamineModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.EXAMINE;
        }
        if (this.options.staffItemsConfiguration.getFollowModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.FOLLOW;
        }
        if (this.options.staffItemsConfiguration.getPlayerDetailsModeConfiguration().getIdentifier().equals(value)) {
            return GadgetType.PLAYER_DETAILS;
        }
        return GadgetType.CUSTOM;
    }

    public void onCompass(Player player) {
        Vector vector = player.getLocation().getDirection();
        player.setVelocity(JavaUtils.makeVelocitySafe(vector.multiply(this.options.staffItemsConfiguration.getCompassModeConfiguration().getVelocity())));
    }

    public void onRandomTeleport(Player player) {
        Player currentPlayer;
        List onlinePlayers = this.playerManager.getOnlinePlayers().stream().filter(p -> !p.getUniqueId().equals(player.getUniqueId()) && !this.permission.has((Player)p, this.randomTeleportBypass)).collect(Collectors.toList());
        if (onlinePlayers.isEmpty()) {
            this.messages.send((CommandSender)player, this.messages.modeNotEnoughPlayers, this.messages.prefixGeneral);
            return;
        }
        if (this.options.staffItemsConfiguration.getRandomTeleportModeConfiguration().isRandom()) {
            Random random = new Random();
            currentPlayer = (Player)onlinePlayers.get(random.nextInt(onlinePlayers.size()));
        } else {
            UUID uuid = player.getUniqueId();
            int lastIndex = lastRandomTeleport.get(uuid) == null ? 0 : lastRandomTeleport.get(uuid);
            lastIndex = lastIndex + 1 < onlinePlayers.size() ? lastIndex + 1 : 0;
            currentPlayer = (Player)onlinePlayers.get(lastIndex);
            lastRandomTeleport.put(uuid, lastIndex);
        }
        this.messages.send((CommandSender)player, this.messages.modeRandomTeleport.replace("%target%", currentPlayer.getName()), this.messages.prefixGeneral);
        player.teleport((Entity)currentPlayer);
    }

    public void onVanish(Player player) {
        PlayerSettings settings = this.playerSettingsRepository.get((OfflinePlayer)player);
        GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode(player, settings.getModeName().get());
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            if (settings.getVanishType() == modeConfiguration.getModeVanish()) {
                this.vanishService.removeVanish(player);
            } else {
                this.vanishService.addVanish(player, modeConfiguration.getModeVanish());
            }
        });
    }

    public void onGuiHub(Player player) {
        this.guiActionService.executeAction(player, "hub/view");
    }

    public void onCounter(Player player) {
        this.guiActionService.executeAction(player, "membersGUI");
    }

    public void onCps(CommandSender sender, Player targetPlayer) {
        if (targetPlayer == null) {
            return;
        }
        this.cpsHandler.startTest(sender, targetPlayer);
    }

    public void onExamine(Player player, SppPlayer targetPlayer) {
        if (targetPlayer == null) {
            return;
        }
        this.guiActionService.executeAction(player, GuiActionBuilder.builder().action("examine/view").param("targetPlayerName", targetPlayer.getUsername()).build());
    }

    public void onFollow(Player player, Player targetPlayer) {
        if (targetPlayer == null || player.equals((Object)targetPlayer)) {
            return;
        }
        if (player.getVehicle() != null) {
            player.getVehicle().eject();
        }
        targetPlayer.addPassenger((Entity)player);
    }

    public void executeModule(Player player, Player targetPlayer, CustomModuleConfiguration customModuleConfiguration, Map<String, String> placeholders) {
        List<String> commands = customModuleConfiguration.getActions();
        for (String action : commands) {
            String command = action.replace("%clicker%", player.getName());
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                command = command.replace(entry.getKey(), entry.getValue());
            }
            if (targetPlayer != null) {
                command = command.replace("%clicked%", targetPlayer.getName());
            }
            switch (customModuleConfiguration.getType()) {
                case COMMAND_STATIC: {
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                    break;
                }
                case COMMAND_DYNAMIC: {
                    if (targetPlayer == null) break;
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                    break;
                }
                case COMMAND_CONSOLE: {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    break;
                }
            }
        }
    }

    public void updateGadgets() {
        Set<Player> modeUsers = this.getModeUsers();
        block0: for (Player player : modeUsers) {
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || this.getGadgetType(this.protocolService.getVersionProtocol().getNbtString(item)) != GadgetType.COUNTER) continue;
                item.setAmount(this.options.staffItemsConfiguration.getCounterModeConfiguration().isModeCounterShowStaffMode() ? modeUsers.size() : this.permission.getStaffCount());
                continue block0;
            }
        }
    }

    private Set<Player> getModeUsers() {
        return this.sessionManager.getAll().stream().filter(IPlayerSession::isInStaffMode).map(s -> this.playerManager.getOnlinePlayer(s.getUuid())).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).map(SppPlayer::getPlayer).collect(Collectors.toSet());
    }
}

