/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.cps.CpsModeConfiguration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@IocBean
public class CpsHandler {
    private static final Map<UUID, Integer> currentTests = new HashMap<UUID, Integer>();
    private final Messages messages;
    private final CpsModeConfiguration cpsModeConfiguration;

    public CpsHandler(Options options, Messages messages) {
        this.messages = messages;
        this.cpsModeConfiguration = options.staffItemsConfiguration.getCpsModeConfiguration();
    }

    public boolean isTesting(UUID uuid) {
        return currentTests.containsKey(uuid);
    }

    public void updateCount(UUID uuid) {
        int count = currentTests.get(uuid);
        currentTests.put(uuid, count + 1);
    }

    public void startTest(final CommandSender sender, final Player targetPlayer) {
        if (currentTests.containsKey(targetPlayer.getUniqueId())) {
            return;
        }
        currentTests.put(targetPlayer.getUniqueId(), 0);
        this.messages.send(sender, this.messages.cpsStart.replace("%target%", targetPlayer.getName()).replace("%seconds%", Integer.toString((int)this.cpsModeConfiguration.getModeCpsTime() / 20)), this.messages.prefixGeneral);
        new BukkitRunnable(){

            public void run() {
                CpsHandler.this.stopTest(sender, targetPlayer);
            }
        }.runTaskLater((Plugin)StaffPlusPlus.get(), this.cpsModeConfiguration.getModeCpsTime());
    }

    public void stopTest(CommandSender sender, Player targetPlayer) {
        UUID uuid = targetPlayer.getUniqueId();
        if (uuid == null) {
            return;
        }
        int cps = (int)((long)currentTests.get(uuid).intValue() / (this.cpsModeConfiguration.getModeCpsTime() / 20L));
        String message = (double)cps > this.cpsModeConfiguration.getModeCpsMax() ? this.messages.cpsFinishMax : this.messages.cpsFinishNormal;
        this.messages.send(sender, message.replace("%player%", targetPlayer.getName()).replace("%cps%", Integer.toString(cps)), this.messages.prefixGeneral);
        currentTests.remove(uuid);
    }
}

