/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.custommodules.preprocessors;

import java.util.Map;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleExecutor;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.preprocessors.CustomModulePreProcessor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@IocBean
@IocMultiProvider(value={CustomModulePreProcessor.class})
public class InputCustomModulePreprocessor
implements CustomModulePreProcessor {
    private static final String CANCEL = "cancel";
    private final Messages messages;
    private final OnlineSessionsManager sessionsManager;

    public InputCustomModulePreprocessor(Messages messages, OnlineSessionsManager sessionsManager) {
        this.messages = messages;
        this.sessionsManager = sessionsManager;
    }

    @Override
    public CustomModuleExecutor process(CustomModuleExecutor action, CustomModuleConfiguration customModuleConfiguration, Map<String, String> placeholders) {
        if (!customModuleConfiguration.isRequireInput()) {
            return action;
        }
        return (player, pl) -> {
            String inputPrompt = customModuleConfiguration.getInputPrompt();
            for (Map.Entry entry : pl.entrySet()) {
                inputPrompt = inputPrompt.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            PlayerSession playerSession = this.sessionsManager.get(player);
            this.messages.send((CommandSender)player, "&7------", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6" + inputPrompt, this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&6 or \"cancel\" to cancel the action", this.messages.prefixGeneral);
            this.messages.send((CommandSender)player, "&7------", this.messages.prefixGeneral);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled this action", this.messages.prefixGeneral);
                    return;
                }
                pl.put("%input%", message);
                Bukkit.getScheduler().runTaskLater((Plugin)StaffPlusPlus.get(), () -> action.execute(player, pl), 1L);
            });
        };
    }
}

