/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.custommodules.preprocessors;

import java.util.Map;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.confirmation.ConfirmationConfig;
import net.shortninja.staffplus.core.domain.confirmation.ConfirmationService;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleExecutor;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.preprocessors.CustomModulePreProcessor;
import org.bukkit.command.CommandSender;

@IocBean
@IocMultiProvider(value={CustomModulePreProcessor.class})
public class ConfirmationCustomModulePreprocessor
implements CustomModulePreProcessor {
    private final Messages messages;
    private final ConfirmationService confirmationService;
    private final BukkitUtils bukkitUtils;

    public ConfirmationCustomModulePreprocessor(Messages messages, ConfirmationService confirmationService, BukkitUtils bukkitUtils) {
        this.messages = messages;
        this.confirmationService = confirmationService;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    public CustomModuleExecutor process(CustomModuleExecutor action, CustomModuleConfiguration customModuleConfiguration, Map<String, String> placeholders) {
        if (!customModuleConfiguration.getConfirmationConfig().isPresent()) {
            return action;
        }
        return (player, pl) -> this.bukkitUtils.runTaskLater((CommandSender)player, () -> {
            ConfirmationConfig confirmationConfig = customModuleConfiguration.getConfirmationConfig().get();
            this.confirmationService.showConfirmation(player, confirmationConfig, pl, player1 -> action.execute(player1, pl), p -> this.messages.send((CommandSender)p, "You have cancelled the action", this.messages.prefixGeneral));
        });
    }
}

