/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.custommodules;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeItemsService;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleExecutor;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.preprocessors.CustomModulePreProcessor;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.state.CustomModuleStateMachine;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetHandler;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
public class CustomModuleHandler {
    private final GadgetHandler gadgetHandler;
    private final CustomModuleStateMachine customModuleStateMachine;
    private final StaffModeItemsService staffModeItemsService;
    private final Messages messages;
    private final List<CustomModulePreProcessor> customModulePreProcessors;

    public CustomModuleHandler(GadgetHandler gadgetHandler, CustomModuleStateMachine customModuleStateMachine, StaffModeItemsService staffModeItemsService, Messages messages, @IocMulti(value=CustomModulePreProcessor.class) List<CustomModulePreProcessor> customModulePreProcessors) {
        this.gadgetHandler = gadgetHandler;
        this.customModuleStateMachine = customModuleStateMachine;
        this.staffModeItemsService = staffModeItemsService;
        this.messages = messages;
        this.customModulePreProcessors = customModulePreProcessors;
    }

    public boolean handleCustomModule(Player player, ItemStack item) {
        Optional<CustomModuleConfiguration> customModuleConfiguration = this.staffModeItemsService.getCustomModule(item);
        if (!customModuleConfiguration.isPresent()) {
            return false;
        }
        CustomModuleConfiguration moduleConfiguration = customModuleConfiguration.get();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%clicker%", player.getName());
        Player targetPlayer = JavaUtils.getTargetPlayer(player);
        if (targetPlayer != null) {
            placeholders.put("%clicked%", targetPlayer.getName());
        }
        if (moduleConfiguration.getType() == CustomModuleConfiguration.ModuleType.COMMAND_DYNAMIC && targetPlayer == null) {
            this.messages.send((CommandSender)player, "No target in range", this.messages.prefixGeneral);
            return true;
        }
        CustomModuleExecutor moduleExecution = (p, pl) -> this.gadgetHandler.executeModule(p, targetPlayer, moduleConfiguration, pl);
        for (CustomModulePreProcessor customModulePreProcessor : this.customModulePreProcessors) {
            moduleExecution = customModulePreProcessor.process(moduleExecution, moduleConfiguration, placeholders);
        }
        moduleExecution.execute(player, placeholders);
        if (moduleConfiguration.getEnableState().isPresent() || moduleConfiguration.getDisableState().isPresent()) {
            this.customModuleStateMachine.switchState(player, moduleConfiguration.getDisableState().orElse(null), moduleConfiguration.getEnableState().orElse(null));
        }
        return true;
    }
}

