/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.custommodules;

import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ToEnum;
import net.shortninja.staffplus.core.domain.confirmation.ConfirmationConfig;
import net.shortninja.staffplus.core.domain.staff.mode.config.ModeItemConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.item.ConfirmationType;

public class CustomModuleConfiguration
extends ModeItemConfiguration {
    @ConfigProperty(value="type")
    @ConfigTransformer(value={ToEnum.class})
    private ModuleType moduleType;
    @ConfigProperty(value="commands")
    private List<String> actions;
    @ConfigProperty(value="confirmation")
    @ConfigTransformer(value={ToEnum.class})
    private ConfirmationType confirmationType;
    @ConfigProperty(value="confirmation-message")
    private String confirmationMessage;
    @ConfigProperty(value="require-input")
    private boolean requireInput;
    @ConfigProperty(value="input-prompt")
    private String inputPrompt;
    @ConfigProperty(value="enabled-on-state")
    private String enabledOnState;
    @ConfigProperty(value="enable-state")
    private String enableState;
    @ConfigProperty(value="disable-state")
    private String disableState;

    public ModuleType getType() {
        return this.moduleType;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public Optional<ConfirmationConfig> getConfirmationConfig() {
        return Optional.ofNullable(this.confirmationType != null ? new ConfirmationConfig(this.confirmationType, this.confirmationMessage) : null);
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public Optional<String> getEnabledOnState() {
        return Optional.ofNullable(this.enabledOnState);
    }

    public Optional<String> getEnableState() {
        return Optional.ofNullable(this.enableState);
    }

    public Optional<String> getDisableState() {
        return Optional.ofNullable(this.disableState);
    }

    public static enum ModuleType {
        COMMAND_STATIC,
        COMMAND_DYNAMIC,
        COMMAND_CONSOLE,
        ITEM;

    }
}

