/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.config;

import java.util.ArrayList;
import java.util.Arrays;
import net.shortninja.staffplus.core.application.config.AbstractConfigLoader;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigurationLoader;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.Items;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.staff.mode.config.ModeItemConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class ModeItemLoader<T extends ModeItemConfiguration>
extends AbstractConfigLoader<T> {
    protected final IProtocolService protocolService;

    protected ModeItemLoader(IProtocolService protocolService, ConfigurationLoader configurationLoader) {
        super(configurationLoader);
        this.protocolService = protocolService;
    }

    protected T loadGeneralConfig(T modeItemConfiguration) {
        String prefix = "modules." + this.getModuleName() + ".";
        boolean enabled = this.staffModeModulesConfig.getBoolean(prefix + "enabled", true);
        boolean movable = this.staffModeModulesConfig.getBoolean(prefix + "movable", true);
        Material type = Options.stringToMaterial(this.sanitize(this.staffModeModulesConfig.getString(prefix + "item")));
        short durability = this.getMaterialData(this.staffModeModulesConfig.getString(prefix + "item"));
        String name = this.staffModeModulesConfig.getString(prefix + "name");
        String commas = this.staffModeModulesConfig.getString(prefix + "lore");
        if (commas == null) {
            throw new IllegalArgumentException("Commas may not be null.");
        }
        ArrayList<String> lore = new ArrayList<String>(Arrays.asList(commas.split("\\s*,\\s*")));
        ItemStack item = Items.builder().setMaterial(type).setData(durability).setName(name).setLore(lore).build();
        ((ModeItemConfiguration)modeItemConfiguration).setEnabled(enabled);
        ((ModeItemConfiguration)modeItemConfiguration).setMovable(movable);
        item = this.protocolService.getVersionProtocol().addNbtString(item, ((ModeItemConfiguration)modeItemConfiguration).getIdentifier());
        ((ModeItemConfiguration)modeItemConfiguration).setItem(item);
        return modeItemConfiguration;
    }

    protected short getMaterialData(String string) {
        short data = 0;
        if (string.contains(":")) {
            String dataString = string.substring(string.lastIndexOf(58) + 1);
            if (JavaUtils.isInteger(dataString)) {
                data = (short)Integer.parseInt(dataString);
            } else {
                Bukkit.getLogger().severe("Invalid material data '" + dataString + "' from '" + string + "'!");
            }
        }
        return data;
    }

    protected abstract String getModuleName();
}

