/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.IConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.yaml.configuration.ConfigurationSection;
import net.shortninja.staffplus.core.common.Items;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ModeItemConfigTransformer
implements IConfigTransformer<ItemStack, Object> {
    @Override
    public ItemStack mapConfig(Object configurationSection) {
        if (configurationSection instanceof LinkedHashMap) {
            LinkedHashMap map = (LinkedHashMap)configurationSection;
            Material type = Options.stringToMaterial(Options.sanitizeMaterial((String)map.get("type")));
            short durability = Options.getMaterialData((String)map.get("type"));
            String name = (String)map.get("name");
            String commas = map.getOrDefault("lore", "");
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList(commas.split("\\s*,\\s*")));
            Items.ItemStackBuilder itemStackBuilder = Items.builder().setMaterial(type).setData(durability).setName(name).setLore(lore);
            if (!map.getOrDefault("enchantment", "").equalsIgnoreCase("")) {
                String enchantInfo = (String)map.get("enchantment");
                String[] enchantInfoParts = enchantInfo.split(":");
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantInfoParts[0]));
                if (enchantment == null) {
                    enchantment = Enchantment.UNBREAKING;
                }
                int level = Integer.parseInt(enchantInfoParts[1]);
                itemStackBuilder.addEnchantment(enchantment, level).build();
            }
            return itemStackBuilder.build();
        }
        if (configurationSection instanceof ConfigurationSection) {
            ConfigurationSection map = (ConfigurationSection)configurationSection;
            Material type = Options.stringToMaterial(Options.sanitizeMaterial(map.getString("type")));
            short durability = Options.getMaterialData(map.getString("type"));
            String name = map.getString("name");
            String commas = map.getString("lore", "");
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList(commas.split("\\s*,\\s*")));
            Items.ItemStackBuilder itemStackBuilder = Items.builder().setMaterial(type).setData(durability).setName(name).setLore(lore);
            if (!map.getString("enchantment", "").equalsIgnoreCase("")) {
                String enchantInfo = map.getString("enchantment");
                String[] enchantInfoParts = enchantInfo.split(":");
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantInfoParts[0]));
                if (enchantment == null) {
                    enchantment = Enchantment.UNBREAKING;
                }
                int level = Integer.parseInt(enchantInfoParts[1]);
                itemStackBuilder.addEnchantment(enchantment, level).build();
            }
            return itemStackBuilder.build();
        }
        return null;
    }
}

