/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.config;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.World;

public class GeneralModeConfiguration {
    private String name;
    private String permission;
    private int weight;
    private VanishType modeVanish;
    private boolean modeItemPickup;
    private boolean modeItemDrop;
    private boolean modeDamage;
    private boolean modeHungerLoss;
    private List<ConfiguredCommand> modeEnableCommands;
    private List<ConfiguredCommand> modeDisableCommands;
    private boolean disableOnWorldChange;
    private boolean modeBlockManipulation;
    private boolean modeInventoryInteraction;
    private boolean modeSilentChestInteraction;
    private boolean modeInvincible;
    private boolean modeFlight;
    private boolean modeCreative;
    private boolean modeOriginalLocation;
    private boolean modeEnableOnLogin;
    private boolean modeDisableOnLogout;
    private boolean nightVision;
    private Map<String, Integer> itemSlots;
    private List<String> validWorlds;
    private Set<String> initialItemStates = new HashSet<String>();
    private boolean vanishOnEnter;

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isModeItemPickup() {
        return this.modeItemPickup;
    }

    public boolean isModeItemDrop() {
        return this.modeItemDrop;
    }

    public VanishType getModeVanish() {
        return this.modeVanish;
    }

    public boolean isModeDamage() {
        return this.modeDamage;
    }

    public boolean isModeHungerLoss() {
        return this.modeHungerLoss;
    }

    public List<ConfiguredCommand> getModeEnableCommands() {
        return this.modeEnableCommands;
    }

    public List<ConfiguredCommand> getModeDisableCommands() {
        return this.modeDisableCommands;
    }

    public boolean isDisableOnWorldChange() {
        return this.disableOnWorldChange;
    }

    public boolean isModeBlockManipulation() {
        return this.modeBlockManipulation;
    }

    public boolean isModeInventoryInteraction() {
        return this.modeInventoryInteraction;
    }

    public boolean isModeSilentChestInteraction() {
        return this.modeSilentChestInteraction;
    }

    public boolean isModeInvincible() {
        return this.modeInvincible;
    }

    public boolean isModeFlight() {
        return this.modeFlight;
    }

    public boolean isModeCreative() {
        return this.modeCreative;
    }

    public boolean isModeOriginalLocation() {
        return this.modeOriginalLocation;
    }

    public boolean isModeEnableOnLogin() {
        return this.modeEnableOnLogin;
    }

    public boolean isModeDisableOnLogout() {
        return this.modeDisableOnLogout;
    }

    public void setModeVanish(VanishType modeVanish) {
        this.modeVanish = modeVanish;
    }

    public void setModeItemPickup(boolean modeItemPickup) {
        this.modeItemPickup = modeItemPickup;
    }

    public void setModeItemDrop(boolean modeItemDrop) {
        this.modeItemDrop = modeItemDrop;
    }

    public void setModeDamage(boolean modeDamage) {
        this.modeDamage = modeDamage;
    }

    public void setModeHungerLoss(boolean modeHungerLoss) {
        this.modeHungerLoss = modeHungerLoss;
    }

    public void setDisableOnWorldChange(boolean disableOnWorldChange) {
        this.disableOnWorldChange = disableOnWorldChange;
    }

    public void setModeBlockManipulation(boolean modeBlockManipulation) {
        this.modeBlockManipulation = modeBlockManipulation;
    }

    public void setModeInventoryInteraction(boolean modeInventoryInteraction) {
        this.modeInventoryInteraction = modeInventoryInteraction;
    }

    public void setModeSilentChestInteraction(boolean modeSilentChestInteraction) {
        this.modeSilentChestInteraction = modeSilentChestInteraction;
    }

    public void setModeInvincible(boolean modeInvincible) {
        this.modeInvincible = modeInvincible;
    }

    public void setModeFlight(boolean modeFlight) {
        this.modeFlight = modeFlight;
    }

    public void setModeCreative(boolean modeCreative) {
        this.modeCreative = modeCreative;
    }

    public void setModeOriginalLocation(boolean modeOriginalLocation) {
        this.modeOriginalLocation = modeOriginalLocation;
    }

    public void setModeEnableOnLogin(boolean modeEnableOnLogin) {
        this.modeEnableOnLogin = modeEnableOnLogin;
    }

    public void setModeDisableOnLogout(boolean modeDisableOnLogout) {
        this.modeDisableOnLogout = modeDisableOnLogout;
    }

    public void setModeEnableCommands(List<ConfiguredCommand> modeEnableCommands) {
        this.modeEnableCommands = modeEnableCommands;
    }

    public void setModeDisableCommands(List<ConfiguredCommand> modeDisableCommands) {
        this.modeDisableCommands = modeDisableCommands;
    }

    public boolean isNightVision() {
        return this.nightVision;
    }

    public void setNightVision(boolean nightVision) {
        this.nightVision = nightVision;
    }

    public Map<String, Integer> getItemSlots() {
        return this.itemSlots;
    }

    public void setItemSlots(Map<String, Integer> itemSlots) {
        this.itemSlots = itemSlots;
    }

    public void setValidWorlds(List<String> validWorlds) {
        this.validWorlds = validWorlds;
    }

    public boolean isModeValidInWorld(World world) {
        if (this.validWorlds == null) {
            return true;
        }
        return this.validWorlds.contains(world.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVanishOnEnter(boolean vanishOnEnter) {
        this.vanishOnEnter = vanishOnEnter;
    }

    public boolean isVanishOnEnter() {
        return this.vanishOnEnter;
    }

    public void setInitialItemStates(Set<String> initialItemStates) {
        this.initialItemStates = initialItemStates;
    }

    public Set<String> getInitialItemStates() {
        return new HashSet<String>(this.initialItemStates);
    }

    public List<String> getModulesWithSameLocation(String module) {
        Integer moduleLocation = this.itemSlots.get(module);
        return this.getModulesInSlot(moduleLocation).stream().filter(s -> !s.equalsIgnoreCase(module)).collect(Collectors.toList());
    }

    private List<String> getModulesInSlot(int slot) {
        return this.itemSlots.entrySet().stream().filter(e -> (Integer)e.getValue() == slot).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

