/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:staff-mode", permissions={"permissions:mode"}, description="Enables or disables staff mode.", usage="[player] [enable | disable]", playerRetrievalStrategy=PlayerRetrievalStrategy.ONLINE)
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class ModeCmd
extends AbstractCmd {
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String MODE_TYPE = "-mode=";
    private final PermissionHandler permissionHandler;
    private final Options options;
    private final StaffModeService staffModeService;
    private final OnlineSessionsManager sessionManager;
    private final PlayerManager playerManager;
    private final BukkitUtils bukkitUtils;
    @ConfigProperty(value="permissions:mode-specific")
    private String permissionModeSpecific;

    public ModeCmd(PermissionHandler permissionHandler, Messages messages, Options options, StaffModeService staffModeService, OnlineSessionsManager sessionManager, CommandService commandService, PlayerManager playerManager, BukkitUtils bukkitUtils) {
        super(messages, permissionHandler, commandService);
        this.permissionHandler = permissionHandler;
        this.options = options;
        this.staffModeService = staffModeService;
        this.sessionManager = sessionManager;
        this.playerManager = playerManager;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        this.bukkitUtils.runTaskAsync(sender, () -> {
            if (args.length == 0) {
                this.validateIsPlayer(sender);
                this.toggleMode((Player)sender);
                return;
            }
            if (args.length == 1) {
                if (args[0].startsWith(MODE_TYPE)) {
                    this.turnOnSpecificStaffMode(sender, args[0]);
                } else {
                    this.permissionHandler.validateOp(sender);
                    this.toggleMode(targetPlayer.getPlayer());
                }
                return;
            }
            this.permissionHandler.validateOp(sender);
            String option = args[1];
            if (option.startsWith(MODE_TYPE)) {
                this.turnOnSpecificStaffMode(sender, args[0]);
            } else {
                switch (option) {
                    case "enable": {
                        this.staffModeService.turnStaffModeOn(targetPlayer.getPlayer());
                        break;
                    }
                    case "disable": {
                        this.staffModeService.turnStaffModeOff(targetPlayer.getPlayer());
                        break;
                    }
                    default: {
                        throw new BusinessException(this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()), this.messages.prefixGeneral);
                    }
                }
            }
        });
        return true;
    }

    private void turnOnSpecificStaffMode(CommandSender sender, String arg) {
        this.validateIsPlayer(sender);
        this.permissionHandler.validate(sender, this.permissionModeSpecific);
        this.staffModeService.turnStaffModeOn((Player)sender, this.getModeName(arg));
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            return 0;
        }
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        if (args.length == 0 && sender instanceof Player) {
            return Optional.of(sender.getName());
        }
        if (args.length == 1 && args[0].startsWith(MODE_TYPE)) {
            return Optional.of(sender.getName());
        }
        return Optional.of(args[0]);
    }

    private void toggleMode(Player player) {
        PlayerSession session = this.sessionManager.get(player);
        if (session.isInStaffMode()) {
            this.staffModeService.turnStaffModeOff(player);
        } else {
            this.staffModeService.turnStaffModeOn(player);
        }
    }

    private String getModeName(String arg) {
        String[] templateParams = arg.split("=");
        if (templateParams.length != 2) {
            throw new BusinessException("&CInvalid mode name provided");
        }
        return templateParams[1];
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            if (currentArg.startsWith("-")) {
                return this.options.modeConfigurations.keySet().stream().map(k -> MODE_TYPE + k).filter(s -> s.contains(currentArg)).collect(Collectors.toList());
            }
            return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (currentArg.startsWith("-")) {
                return this.options.modeConfigurations.keySet().stream().map(k -> MODE_TYPE + k).filter(s -> s.contains(currentArg)).collect(Collectors.toList());
            }
            return Stream.of(ENABLE, DISABLE).filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

