/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.staffmode.EnterStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.SwitchStaffModeEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class StaffModeActionHook
implements Listener {
    private final PlayerManager playerManager;
    private final ModeProvider modeProvider;
    private final ActionService actionService;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final BukkitUtils bukkitUtils;

    public StaffModeActionHook(PlayerManager playerManager, ModeProvider modeProvider, ActionService actionService, ConfiguredCommandMapper configuredCommandMapper, BukkitUtils bukkitUtils) {
        this.playerManager = playerManager;
        this.modeProvider = modeProvider;
        this.actionService = actionService;
        this.configuredCommandMapper = configuredCommandMapper;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void enterMode(EnterStaffModeEvent event) {
        this.onEnter(event.getPlayerUuid(), event.getMode());
    }

    @EventHandler
    public void exitMode(ExitStaffModeEvent event) {
        this.onExit(event.getPlayerUuid(), event.getMode());
    }

    @EventHandler
    public void switchMode(SwitchStaffModeEvent event) {
        this.onExit(event.getPlayerUuid(), event.getFromMode());
        this.onEnter(event.getPlayerUuid(), event.getToMode());
    }

    private void onEnter(UUID playerUuid, String toMode) {
        Optional<SppPlayer> staff = this.playerManager.getOnOrOfflinePlayer(playerUuid);
        Optional<GeneralModeConfiguration> modeConfiguration = this.modeProvider.getConfiguration(toMode);
        if (staff.isPresent() && modeConfiguration.isPresent()) {
            this.executeCommands(staff.get(), modeConfiguration.get().getModeEnableCommands());
        }
    }

    private void onExit(UUID playerUuid, String mode) {
        Optional<SppPlayer> staff = this.playerManager.getOnOrOfflinePlayer(playerUuid);
        Optional<GeneralModeConfiguration> modeConfiguration = this.modeProvider.getConfiguration(mode);
        if (staff.isPresent() && modeConfiguration.isPresent()) {
            this.executeCommands(staff.get(), modeConfiguration.get().getModeDisableCommands());
        }
    }

    private void executeCommands(SppPlayer staff, List<ConfiguredCommand> modeCommands) {
        if (modeCommands.isEmpty()) {
            return;
        }
        this.bukkitUtils.runTaskAsync(() -> {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%staff%", staff.getUsername());
            HashMap<String, OfflinePlayer> targets = new HashMap<String, OfflinePlayer>();
            targets.put("staff", staff.getOfflinePlayer());
            List<CreateStoredCommandRequest> commandCreateRequest = this.configuredCommandMapper.toCreateRequests(modeCommands, placeholders, targets, Collections.emptyList());
            this.actionService.createCommands(commandCreateRequest);
        });
    }
}

