/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;

@IocBukkitListener
public class StaffModeWorldChangeListener
implements Listener {
    private final StaffModeService staffModeService;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;

    public StaffModeWorldChangeListener(StaffModeService staffModeService, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils) {
        this.staffModeService = staffModeService;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWorldChange(PlayerTeleportEvent event) {
        boolean worldChanged;
        PlayerSession session = this.sessionManager.get(event.getPlayer());
        World currentWorld = event.getPlayer().getWorld();
        if (event.getTo() == null) {
            return;
        }
        World toWorld = event.getTo().getWorld();
        boolean bl = worldChanged = !currentWorld.equals((Object)toWorld);
        if (!worldChanged || !session.isInStaffMode()) {
            return;
        }
        if (session.getModeConfig().get().isDisableOnWorldChange() || !session.getModeConfig().get().isModeValidInWorld(toWorld)) {
            this.bukkitUtils.runTaskAsync((CommandSender)event.getPlayer(), () -> this.staffModeService.turnStaffModeOffAndTeleport(event.getPlayer(), event.getTo()));
            event.setCancelled(true);
        }
    }
}

