/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import java.util.ArrayList;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeData;
import net.shortninja.staffplus.core.domain.staff.mode.ModeDataRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.staffmode.EnterStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.ExitStaffModeEvent;
import net.shortninja.staffplusplus.staffmode.SwitchStaffModeEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
public class StaffModeService {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final ModeDataRepository modeDataRepository;
    private final Options options;
    private final ModeProvider modeProvider;

    public StaffModeService(Options options, PlayerSettingsRepository playerSettingsRepository, ModeDataRepository modeDataRepository, ModeProvider modeProvider) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.options = options;
        this.modeDataRepository = modeDataRepository;
        this.modeProvider = modeProvider;
    }

    public void turnStaffModeOn(Player player, String mode) {
        GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode(player, mode);
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (session.isInStaffMode()) {
            this.switchStaffMode(player, modeConfiguration);
        } else {
            this.turnStaffModeOn(player, modeConfiguration);
        }
    }

    public void turnStaffModeOn(Player player) {
        GeneralModeConfiguration modeConfiguration = this.modeProvider.calculateMode(player).orElseThrow(() -> new BusinessException("&CNo suitable staff mode found. Can't enable staff mode"));
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (session.isInStaffMode()) {
            this.switchStaffMode(player, modeConfiguration);
        } else {
            this.turnStaffModeOn(player, modeConfiguration);
        }
    }

    private void switchStaffMode(Player player, GeneralModeConfiguration modeConfiguration) {
        PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
        Optional<ModeData> existingModeData = this.modeDataRepository.retrieveModeData(player.getUniqueId());
        if (!existingModeData.isPresent()) {
            return;
        }
        playerSettings.setInStaffMode(true);
        playerSettings.setModeConfiguration(modeConfiguration);
        this.playerSettingsRepository.save(playerSettings);
        BukkitUtils.sendEvent(new SwitchStaffModeEvent(player.getName(), player.getUniqueId(), player.getLocation(), this.options.serverName, playerSettings.getName(), modeConfiguration.getName(), existingModeData.get()));
    }

    public void turnStaffModeOn(Player player, GeneralModeConfiguration modeConfiguration) {
        PlayerSettings settings = this.playerSettingsRepository.get((OfflinePlayer)player);
        Optional<ModeData> existingModeData = this.modeDataRepository.retrieveModeData(player.getUniqueId());
        if (!existingModeData.isPresent()) {
            ModeData modeData = new ModeData(player, settings.getVanishType());
            this.modeDataRepository.saveModeData(modeData);
        }
        settings.setInStaffMode(true);
        settings.setModeConfiguration(modeConfiguration);
        this.playerSettingsRepository.save(settings);
        BukkitUtils.sendEvent(new EnterStaffModeEvent(player.getName(), player.getUniqueId(), player.getLocation(), this.options.serverName, modeConfiguration.getName()));
    }

    public void toggleStaffFly(Player player) {
        PlayerSettings playerSession = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (!playerSession.isInStaffMode()) {
            throw new BusinessException("&CYou can only toggle fly while in staff mode");
        }
        Optional<GeneralModeConfiguration> modeConfiguration = this.modeProvider.getConfiguration(playerSession.getModeName().orElse(null));
        if (modeConfiguration.isPresent() && !modeConfiguration.get().isModeFlight()) {
            throw new BusinessException("&CCannot toggle fly. Flight is not enabled while in staff mode");
        }
        player.setAllowFlight(!player.getAllowFlight());
    }

    public void turnStaffModeOffAndTeleport(Player player, Location location) {
        Optional<ModeData> existingModeData = this.modeDataRepository.retrieveModeData(player.getUniqueId());
        if (!existingModeData.isPresent()) {
            return;
        }
        PlayerSettings settings = this.playerSettingsRepository.get((OfflinePlayer)player);
        Optional<GeneralModeConfiguration> modeConfiguration = this.modeProvider.getConfiguration(settings.getModeName().orElse(null));
        settings.setInStaffMode(false);
        settings.setModeName(null);
        this.playerSettingsRepository.save(settings);
        this.modeDataRepository.deleteModeData(player);
        BukkitUtils.sendEvent(new ExitStaffModeEvent(player.getName(), player.getUniqueId(), player.getLocation(), this.options.serverName, modeConfiguration.map(GeneralModeConfiguration::getName).orElse("default"), existingModeData.get(), location));
    }

    public void turnStaffModeOff(Player player) {
        this.turnStaffModeOffAndTeleport(player, null);
    }

    public void turnStaffModeOffOnQuit(Player player) {
        PlayerSettings settings = this.playerSettingsRepository.get((OfflinePlayer)player);
        settings.setInStaffMode(false);
        settings.setModeName(null);
        this.playerSettingsRepository.save(settings);
        Optional<ModeData> existingModeData = this.modeDataRepository.retrieveModeData(player.getUniqueId());
        if (!existingModeData.isPresent()) {
            return;
        }
        Optional<GeneralModeConfiguration> modeConfiguration = this.modeProvider.getConfiguration(settings.getModeName().orElse(null));
        this.modeDataRepository.deleteModeData(player);
        BukkitUtils.sendEventOnThisTick(new ExitStaffModeEvent(player.getName(), player.getUniqueId(), player.getLocation(), this.options.serverName, modeConfiguration.map(GeneralModeConfiguration::getName).orElse("default"), existingModeData.get(), null));
    }

    public static ItemStack[] getContents(Player p) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i <= 35; ++i) {
            itemStacks.add(p.getInventory().getItem(i));
        }
        return itemStacks.toArray(new ItemStack[0]);
    }

    public Optional<GeneralModeConfiguration> getModeConfig(Player player) {
        return this.modeProvider.calculateMode(player);
    }
}

