/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.TubingBukkitPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.BeforeTubingReload;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={BeforeTubingReload.class})
public class StaffModePluginDisable
implements BeforeTubingReload {
    private final StaffModeService staffModeService;
    private final ModeProvider modeProvider;
    private final PlayerSettingsRepository playerSettingsRepository;

    public StaffModePluginDisable(StaffModeService staffModeService, ModeProvider modeProvider, PlayerSettingsRepository playerSettingsRepository) {
        this.staffModeService = staffModeService;
        this.modeProvider = modeProvider;
        this.playerSettingsRepository = playerSettingsRepository;
    }

    @Override
    public void execute(TubingBukkitPlugin tubingPlugin) {
        this.disable();
    }

    private void disable() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            try {
                GeneralModeConfiguration mode;
                PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)onlinePlayer);
                if (!playerSettings.isInStaffMode() || !(mode = this.modeProvider.getMode(onlinePlayer, playerSettings.getModeName().get())).isModeDisableOnLogout()) continue;
                this.staffModeService.turnStaffModeOffOnQuit(onlinePlayer);
            }
            catch (Exception e) {
                StaffPlusPlus.get().getLogger().warning("Enable to execute staff mode disable for user: [" + onlinePlayer.getName() + "]");
            }
        }
    }
}

