/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.mode.ModeProvider;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModule;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.config.ModeItemConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.config.modeitems.vanish.VanishModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.state.CustomModuleStateMachine;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
public class StaffModeItemsService {
    private static final Logger logger = StaffPlusPlus.get().getLogger();
    private final List<ModeItemConfiguration> MODE_ITEMS;
    private final PlayerSettingsRepository playerSettingsRepository;
    private final List<CustomModuleConfiguration> customModuleConfigurations;
    private final CustomModuleStateMachine customModuleStateMachine;
    private final IProtocolService protocolService;
    private final ModeProvider modeProvider;

    public StaffModeItemsService(Options options, PlayerSettingsRepository playerSettingsRepository, CustomModuleStateMachine customModuleStateMachine, IProtocolService protocolService, @ConfigProperty(value="staffmode-custom-modules:custom-modules") @ConfigObjectList(value=CustomModuleConfiguration.class) List<CustomModuleConfiguration> customModuleConfigurations, ModeProvider modeProvider) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.customModuleConfigurations = customModuleConfigurations;
        this.modeProvider = modeProvider;
        this.MODE_ITEMS = Stream.of(Arrays.asList(options.staffItemsConfiguration.getCompassModeConfiguration(), options.staffItemsConfiguration.getRandomTeleportModeConfiguration(), options.staffItemsConfiguration.getVanishModeConfiguration(), options.staffItemsConfiguration.getGuiModeConfiguration(), options.staffItemsConfiguration.getCounterModeConfiguration(), options.staffItemsConfiguration.getFreezeModeConfiguration(), options.staffItemsConfiguration.getCpsModeConfiguration(), options.staffItemsConfiguration.getExamineModeConfiguration(), options.staffItemsConfiguration.getFollowModeConfiguration(), options.staffItemsConfiguration.getPlayerDetailsModeConfiguration()), customModuleConfigurations).flatMap(Collection::stream).collect(Collectors.toList());
        this.customModuleStateMachine = customModuleStateMachine;
        this.protocolService = protocolService;
    }

    public void setModuleItem(Player player, StaffModule staffModule, int slot) {
        PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
        GeneralModeConfiguration modeConfiguration = this.modeProvider.getMode(player, playerSettings.getModeName().get());
        this.setItem(player, modeConfiguration, playerSettings, staffModule.getKey(), slot);
    }

    public void setStaffModeItems(Player player, GeneralModeConfiguration modeConfiguration) {
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
        JavaUtils.clearInventory(player);
        modeConfiguration.getItemSlots().forEach((moduleName, slot) -> this.setItem(player, modeConfiguration, session, (String)moduleName, (int)slot));
    }

    public void refreshStaffModeItems(Player player, GeneralModeConfiguration modeConfiguration) {
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
        Map<String, Integer> currentLocationsOfModules = this.getCurrentLocationsOfModules(player);
        JavaUtils.clearInventory(player);
        modeConfiguration.getItemSlots().forEach((moduleName, slot) -> {
            int locationOfItem = this.getNewLocationOfModuleItem((String)moduleName, modeConfiguration, currentLocationsOfModules);
            this.setItem(player, modeConfiguration, session, (String)moduleName, locationOfItem);
        });
    }

    public void setItem(Player player, GeneralModeConfiguration modeConfiguration, PlayerSettings session, String moduleName, int locationOfItem) {
        CustomModuleConfiguration customModuleConfiguration;
        Optional<? extends ModeItemConfiguration> module = this.getModule(moduleName);
        if (!module.isPresent()) {
            logger.warning("No module found with name [" + moduleName + "]. Skipping...");
            return;
        }
        ModeItemConfiguration modeItem = module.get();
        if (!modeItem.isEnabled()) {
            return;
        }
        if (modeItem instanceof CustomModuleConfiguration && (customModuleConfiguration = (CustomModuleConfiguration)modeItem).getEnabledOnState().isPresent() && !this.customModuleStateMachine.isActive(player, customModuleConfiguration.getEnabledOnState().get())) {
            return;
        }
        if (modeItem instanceof VanishModeConfiguration) {
            ItemStack modeVanishItem = ((VanishModeConfiguration)modeItem).getModeVanishItem(session, modeConfiguration.getModeVanish());
            ItemStack item = this.protocolService.getVersionProtocol().addNbtString(modeVanishItem, modeItem.getIdentifier());
            player.getInventory().setItem(locationOfItem, item);
        } else {
            ItemStack item = this.protocolService.getVersionProtocol().addNbtString(modeItem.getItem(), modeItem.getIdentifier());
            player.getInventory().setItem(locationOfItem, item);
        }
    }

    public Optional<? extends ModeItemConfiguration> getModule(String name) {
        return this.MODE_ITEMS.stream().filter(m -> m.getIdentifier().equals(name)).findFirst();
    }

    public Optional<CustomModuleConfiguration> getCustomModule(String name) {
        return this.customModuleConfigurations.stream().filter(m -> m.getIdentifier().equals(name)).findFirst();
    }

    public Optional<? extends ModeItemConfiguration> getModule(ItemStack item) {
        String identifier = this.protocolService.getVersionProtocol().getNbtString(item);
        return this.getModule(identifier);
    }

    public Optional<CustomModuleConfiguration> getCustomModule(ItemStack item) {
        String identifier = this.protocolService.getVersionProtocol().getNbtString(item);
        return this.getCustomModule(identifier);
    }

    private int getNewLocationOfModuleItem(String moduleToSet, GeneralModeConfiguration modeConfiguration, Map<String, Integer> currentLocationsOfModules) {
        if (currentLocationsOfModules.containsKey(moduleToSet)) {
            return currentLocationsOfModules.get(moduleToSet);
        }
        List<String> modulesWithSameLocation = modeConfiguration.getModulesWithSameLocation(moduleToSet);
        for (String module : modulesWithSameLocation) {
            if (!currentLocationsOfModules.containsKey(module)) continue;
            return currentLocationsOfModules.get(module);
        }
        return modeConfiguration.getItemSlots().get(moduleToSet);
    }

    private Map<String, Integer> getCurrentLocationsOfModules(Player player) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            String moduleName;
            ItemStack item = contents[i];
            if (item == null || !StringUtils.isNotEmpty(moduleName = this.protocolService.getVersionProtocol().getNbtString(item))) continue;
            result.put(moduleName, i);
        }
        return result;
    }
}

