/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.mode;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.mode.handler.CpsHandler;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetHandler;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class StaffModeGuiController {
    private final CpsHandler cpsHandler;
    private final GadgetHandler gadgetHandler;
    private final PlayerManager playerManager;

    public StaffModeGuiController(CpsHandler cpsHandler, GadgetHandler gadgetHandler, PlayerManager playerManager) {
        this.cpsHandler = cpsHandler;
        this.gadgetHandler = gadgetHandler;
        this.playerManager = playerManager;
    }

    @GuiAction(value="staff-mode/cps")
    public void startCps(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        this.cpsHandler.startTest((CommandSender)player, sppPlayer.getPlayer());
    }

    @GuiAction(value="staff-mode/follow")
    public void follow(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        this.gadgetHandler.onFollow(player, sppPlayer.getPlayer());
    }
}

